<?php

global $wpdb, $chatting_crm_ajaxurl, $tbl_chatting_crm_questions, $tbl_chatting_crm_questions_answers;

?>

<div class="wrapper">
    <div class="row mt-5 justify-content-center">
        <div class="col-md-8">
            <h3>Questions</h3>
        </div>
        <div class="col-md-3 text-end">
            <button type="button" class="btn btn-info text-white" id="btn_add_question">Add New</button>
        </div>
    </div>
    <div class="row mt-3 justify-content-center">
        <div class="col-md-11">
            <table id="myTable" class="display">
                <thead>
                    <tr>
                        <th width="10%">No.</th>
                        <th width="60%">Question</th>
                        <th width="20%">Keywords</th>
                        <th width="10%">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                        $questions_data = $wpdb->get_results("SELECT * FROM $tbl_chatting_crm_questions ORDER BY id DESC");
                        if(isset($questions_data) && count($questions_data) > 0) {
                            foreach($questions_data as $key => $question) 
                            {
                                $question_id = $question->id;
                ?>
                                <tr>
                                    <td><?php echo $key+1; ?></td>
                                    <td><?php echo $question->question_detail; ?></td>
                                    <td><?php echo $question->question_search_keyword; ?></td>
                                    <td><button type="button" class="btn btn-danger">Delete</button></td>
                                </tr>
                <?php
                            }
                        }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade mt-3" id="add_question_modal" tabindex="-1" aria-hidden="true">
    <form method="POST" id="question_form">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Question</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Question</label>
                                <input type="text" class="form-control" placeholder="Enter Question Name" name="question_name">
                            </div>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Answer Options</label>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="form-label">Answer 1: </label>
                                </div>
                                <div class="col-md-8">
                                    <input type="text" class="form-control" name="answers[]">
                                </div>
                            </div>
                            <div class="row mt-1">
                                <div class="col-md-3">
                                    <label class="form-label">Answer 2: </label>
                                </div>
                                <div class="col-md-8">
                                    <input type="text" class="form-control" name="answers[]">
                                </div>
                            </div>
                            <div class="row mt-1">
                                <div class="col-md-3">
                                    <label class="form-label">Answer 3: </label>
                                </div>
                                <div class="col-md-8">
                                    <input type="text" class="form-control" name="answers[]">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Keywords</label>
                                <input type="text" class="form-control" placeholder="Enter comma separated keywords" name="keywords">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-success" id="btn_save">Save changes</button>
                </div>
            </div>
        </div>
    </form>
</div>


<script>
    jQuery(document).ready(function () {
        jQuery('#myTable').DataTable({
            bLengthChange: false,
        });
    });

    jQuery(document).on('click', '#btn_add_question', function () {
        jQuery("#add_question_modal").modal('show');
    });

    jQuery(document).on('click', '#btn_save', function(e){
        var form_data = jQuery("#question_form").serialize();
        jQuery.post('<?php echo $chatting_crm_ajaxurl.'?action=crm_question_save_questions'; ?>', form_data, function(data){
            location.reload();
        });
    });
</script>