<?php
/*
    Plugin Name: Chatting CRM
    Description: Chatting CRM
    Version: 1.0
    Requires at least: 5.0
    Requires PHP:      5.6
    Author: Cryptic Solutions
    Text Domain: chatting-crm
    Domain Path: /languages
 */

if( !defined( 'CHATTING_CRM_DIR_NAME') ){
    define('CHATTING_CRM_DIR_NAME', dirname(plugin_basename(__FILE__)));
}

if( !defined( 'CHATTING_CRM_DIR' ) ){
    define('CHATTING_CRM_DIR', WP_PLUGIN_DIR . '/' . CHATTING_CRM_DIR_NAME);
}

 require_once 'config/load_configs.php';

 require_once 'installer/install.php';

 global $wp, $wpdb, $tbl_chatting_crm_conversations, $tbl_chatting_crm_questions, $tbl_chatting_crm_questions_answers;

$tbl_chatting_crm_conversations      = $wpdb->prefix . 'chatting_crm_conversations';
$tbl_chatting_crm_questions          = $wpdb->prefix . 'chatting_crm_questions';
$tbl_chatting_crm_questions_answers  = $wpdb->prefix . 'chatting_crm_questions_answers';

register_activation_hook(__FILE__, 'install');
function install(){
    global $wpdb;
    $_version = get_option('chatting_crm_version');
    if (empty($_version) || $_version == '' ) {
        include_once ABSPATH . 'wp-admin/includes/upgrade.php';
        @set_time_limit(0);
        global $wpdb, $chatting_crm_version;

        $charset_collate = '';
        if ($wpdb->has_cap('collation') ) {
            if (! empty($wpdb->charset) ) {
                $charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";
            }
            if (! empty($wpdb->collate) ) {
                $charset_collate .= " COLLATE $wpdb->collate";
            }
        }

        update_option('chatting_crm_version', $chatting_crm_version);
        update_option('chatting_crm_plugin_activated', 1);
        update_option('chatting_crm_timezone', wp_timezone_string() );

        $chatting_crm_dbtbl_create = array();
        global $tbl_chatting_crm_conversations, $tbl_chatting_crm_questions, $tbl_chatting_crm_questions_answers;

        $sql_table = "CREATE TABLE IF NOT EXISTS `{$tbl_chatting_crm_conversations}`(
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `chat_session_id` TEXT DEFAULT NULL,
            `selected_question` TEXT DEFAULT NULL,
            `received_answers` INT(11) NOT NULL,
            `chatting_crm_date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`)
        ) {$charset_collate};";
        $chatting_crm_dbtbl_create[ $tbl_chatting_crm_conversations ] = dbDelta($sql_table);

        $sql_table = "CREATE TABLE IF NOT EXISTS `{$tbl_chatting_crm_questions}`(
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `user_id` INT(11) DEFAULT 0,
            `question_detail` TEXT DEFAULT NULL,
            `question_search_keyword` TEXT DEFAULT NULL,
            `chatting_crm_date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`)
        ) {$charset_collate};";
        $chatting_crm_dbtbl_create[ $tbl_chatting_crm_conversations ] = dbDelta($sql_table);

        $sql_table = "CREATE TABLE IF NOT EXISTS `{$tbl_chatting_crm_questions_answers}`(
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `user_id` INT(11) DEFAULT 0,
            `question_id` INT(11) NOT NULL,
            `answer_detail` TEXT DEFAULT NULL,
            `chatting_crm_date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`)
        ) {$charset_collate};";
        $chatting_crm_dbtbl_create[ $tbl_chatting_crm_questions_answers ] = dbDelta($sql_table);
    }
}

function menu_position( $start, $increment = 0.1 )
{
    foreach ( $GLOBALS['menu'] as $key => $menu ) {
        $menus_positions[] = floatval($key);
    }
    if (! in_array($start, $menus_positions) ) {
        $start = strval($start);
        return $start;
    } else {
        $start += $increment;
    }
    /* the position is already reserved find the closet one */
    while ( in_array($start, $menus_positions) ) {
        $start += $increment;
    }
    $start = strval($start);
    return $start;
}

add_action('admin_menu', 'chatting_crm_menu', 26);
function chatting_crm_menu()
{
    $place = menu_position(26.1, 0.3);
    add_menu_page('Chatting CRM', 'Chatting CRM', 'manage_options', 'chatting-crm-questions', 'route', '', $place);
    add_submenu_page('chatting-crm-questions', 'Questions', 'Questions', 'manage_options', 'chatting-crm-questions');
    //add_submenu_page('chatting-crm-questions', 'Test Submenu', 'Test Submenu', 'manage_options', 'chatting-crm-test', 'route');
}

function route()
{
    if (isset($_REQUEST['page']) ) {
        if ( $_REQUEST['page'] == "chatting-crm-questions" ) {
            include 'views/crm-questions.php';
        }
    }
}

add_action('admin_enqueue_scripts', 'set_admin_js', 11);
function set_admin_js(){
    global $chatting_crm_version;
    if ( !empty($_REQUEST['page']) && $_REQUEST['page'] == "chatting-crm-questions" ) {
        wp_register_script('chatting_crm_bootstrap_js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js', array(), $chatting_crm_version, true);
        wp_enqueue_script('chatting_crm_bootstrap_js');

        wp_register_script('chatting_crm_datatable_js', 'https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js', array(), $chatting_crm_version, true);
        wp_enqueue_script('chatting_crm_datatable_js');
    }
}


add_action('admin_enqueue_scripts', 'set_admin_css', 11);
function set_admin_css(){
    global $chatting_crm_version;
    if ( !empty($_REQUEST['page']) && $_REQUEST['page'] == "chatting-crm-questions" ) {
        wp_register_style('chatting_crm_bootstrap', 'https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css', array(), $chatting_crm_version);
        wp_enqueue_style('chatting_crm_bootstrap');

        wp_register_style('chatting_crm_datatable_css', 'https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css', array(), $chatting_crm_version);
        wp_enqueue_style('chatting_crm_datatable_css');
    }
}

add_action("wp_ajax_crm_question_save_questions", "crm_question_save_questions");
function crm_question_save_questions(){
    global $wpdb, $tbl_chatting_crm_questions, $tbl_chatting_crm_questions_answers;

    $question_name = !empty($_POST['question_name']) ? $_POST['question_name'] : '';
    $question_answers = !empty($_POST['answers']) ? $_POST['answers'] : array();
    $keywords = !empty($_POST['keywords']) ? $_POST['keywords'] : '';

    //Insert questions
    $wpdb->insert($tbl_chatting_crm_questions, array(
        'user_id' => get_current_user_id(),
        'question_detail' => $question_name,
        'question_search_keyword' => $keywords,
    ));

    $inserted_question_id = $wpdb->insert_id;

    //Insert answers
    if(is_array($question_answers) && count($question_answers) > 0){
        foreach($question_answers as $question_answer){
            if(!empty($question_answer)){
                $wpdb->insert($tbl_chatting_crm_questions_answers, array(
                    'user_id' => get_current_user_id(),
                    'question_id' => $inserted_question_id,
                    'answer_detail' => $question_answer
                ));
            }
        }
    }
}


add_action('wp_footer', 'set_front_js', 1);
function set_front_js(){
    global $chatting_crm_version, $chatting_crm_ajaxurl;
    echo "<script>";
    echo "var chatting_crm_ajax_url = '".$chatting_crm_ajaxurl."';";
    echo "</script>";
    wp_register_script('chatting-crm-widget', get_home_url().'/wp-content/plugins/chatting-crm/js/widget.js', array(), $chatting_crm_version);
    wp_enqueue_script('chatting-crm-widget');
    wp_register_script('chatting-crm-widget-icon-js', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/js/all.min.js', array(), $chatting_crm_version);
    wp_enqueue_script('chatting-crm-widget-icon-js');
}

add_action('wp_head', 'set_front_css', 1);
function set_front_css(){
    global $chatting_crm_version, $chatting_crm_ajaxurl;
    wp_register_style('chatting-crm-widget-icon-css', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css', array(), $chatting_crm_version);
    wp_enqueue_style('chatting-crm-widget-icon-css');
}

add_action("wp_ajax_nopriv_crm_load_widget", "crm_load_widget");
function crm_load_widget(){
    global $wpdb;
    if (!isset($_COOKIE['chatting_crm_session'])) {
        $cookie_val = md5(uniqid());
        setcookie('chatting_crm_session', $cookie_val, strtotime('+1 day'));
    }else{
        $cookie_val = $_COOKIE['chatting_crm_session'];
    }

    ob_start();
    include "views/frontend-widget.php";
    $return_html = ob_get_clean();

    echo $return_html;
    die;
}

add_action("wp_ajax_nopriv_chatting_crm_get_answers", "chatting_crm_get_answers");
function chatting_crm_get_answers(){
    global $wpdb, $tbl_chatting_crm_questions, $tbl_chatting_crm_questions_answers;

    $return_html = "";

    $crm_question = !empty($_POST['crm_question']) ? $_POST['crm_question'] : '';
    $chatting_session_id = $_COOKIE['chatting_crm_session'];

    $questions_data = $wpdb->get_row("SELECT * FROM $tbl_chatting_crm_questions WHERE question_detail LIKE '%".$crm_question."%' OR question_search_keyword LIKE '%".$crm_question."%'");

    if(!empty($crm_question) && !empty($questions_data)){
        $question_id = $questions_data->id;

        //Find answers of question
        $answers_data = $wpdb->get_results("SELECT * FROM $tbl_chatting_crm_questions_answers WHERE question_id = ".$question_id);
        if(is_array($answers_data) && count( $answers_data ) > 0){
            $return_html .= '<div class="receiver_msg">';
            foreach($answers_data as $answer_data){
                $return_html .= '<p>'.$answer_data->answer_detail.'</p>';
            }
            $return_html .= '</div>';
        }
    }else{
        //$return_html = '<div class="warning_msg"><p>If you couldn\'t find your answer then send us an email with your query on <strong>test@test.com</strong></p></div>';
        $return_html = '<div class="warning_msg"><p>No result found. <br/> Please send us an email with your query on <strong>test@test.com</strong></p></div>';
    }
    
    echo $return_html;
    die;
}