<?php
ini_set('max_execution_time', 1800);
require("dbconnect.php");

$fp = fopen('status_check_api_logs.txt', 'a');
fwrite($fp, "\n");
fwrite($fp, '=================================================================');  
fwrite($fp, "\n");
fwrite($fp, "Date --> ".date('Y-m-d H:i:s'));
fwrite($fp, "\n");

$date = !empty($_GET['date']) ? $_GET['date'] : date('Y-m-d');

$sql = "SELECT gatewayTransactionId, client_transaction_id, callback_url, success_url, fail_url, grossPrice, ipn_no FROM t_master_sales where `status` = 'Process' AND g_type = 'OneSW_BKN' AND `rec_crt_date` LIKE '%".$date."%' LIMIT 100";
$result = mysqli_query($conn, $sql);
if (mysqli_num_rows($result) > 0) {
    while($row = mysqli_fetch_assoc($result)) {
        $payment_id = $row['gatewayTransactionId'];
        $client_transaction_id = $row['client_transaction_id'];
        $callback_url = $row["callback_url"];
        $success_url = $row["success_url"];
        $fail_url = $row["fail_url"];
        $amount = floatval($row['grossPrice']);
        $email_address = $row['customer_email'];
        $ipn_no = $row['ipn_no'];

        fwrite($fp, "Client transaction ID --> ".$client_transaction_id." | PaymentID --> ".$payment_id);
        fwrite($fp, "\n");

        if(!empty($payment_id) && $payment_id != "NA"){
            $payment_curl = curl_init();
            curl_setopt_array($payment_curl, array(
                CURLOPT_URL => 'https://api.301pay.sm/api/1.0/payments/'.$payment_id,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_HTTPHEADER => array(
                    'x-LiveMode:true',
                    'x-SubmerchantId: 65001d19dc63d98c74f47185',
                    "x-SubmerchantApiKey: HhL1pBOz_lD7hxealKKQG-7mLv08QArItFPuqH9xqm9wYagBO-0I8Zj7_YTGNkXAy2mHWQriWqfEvssSfzDaj46TyZ8U8yiPUz3v",
                    "Content-Type: application/json",
                ),
            ));
            $payment_response = $payment_data_res = curl_exec($payment_curl);
            curl_close($payment_curl);

            fwrite($fp, "Payment status response --> ".$payment_response);
            fwrite($fp, "\n");

            $payment_response = json_decode($payment_response, TRUE);

            //Payment status
            $payment_status = !empty($payment_response['status']) ? $payment_response['status'] : '';

            if(!empty($payment_status)){
                $update_status = "";
                $response = "";
                if($payment_status == "succeeded"){
                    $update_status = $response = "Success";
                }else if($payment_status == "pending"){
                    $update_status = $response = "Process";
                }else if($payment_status == "created" ){
                    $update_status = "Process";
                    $response = "Created";
                }else if($payment_status == "failed"){
                    $update_status = $response = "Declined";
                }else if($payment_status == "canceled"){
                    $update_status = "Declined";
                    $response = "Canceled";
                }else if($payment_status == "authorizing"){
                    $update_status = "Process";
                    $response = "Authorizing";
                }else if($payment_status == "requiresCapture"){
                    $update_status = "Process";
                    $response = "RequiresCapture";
                }

                fwrite($fp, "Update status --> ".$update_status);
                fwrite($fp, "\n");

                if(!empty($update_status)){
                    $updateTransactionSQL = "UPDATE t_master_sales SET response = '" . $response . "', status='" . $update_status . "', rec_up_date='" . date('Y-m-d H:i:s') . "' WHERE client_transaction_id='" . $client_transaction_id . "'";
                    $updated = mysqli_query($conn, $updateTransactionSQL);

                    if(!empty($callback_url) && ($update_status == "Success" || $update_status == "Declined")){
                        $arr = array('transaction_id' => $client_transaction_id, 'status' => $update_status, 'paid_amount' => $amount);
                        $data =  http_build_query($arr);
                        $curl = curl_init($callback_url);
                        curl_setopt($curl,CURLOPT_SSL_VERIFYPEER, 0);
                        curl_setopt($curl,CURLOPT_HEADER, 0 );
                        curl_setopt($curl,CURLOPT_RETURNTRANSFER, 1);
                        curl_setopt($curl,CURLOPT_POST, true);
                        curl_setopt($curl,CURLOPT_POSTFIELDS, $data);
                        $xmlrs = curl_exec($curl); 
                        curl_close($curl);
    
                        $sqlResponse = "INSERT INTO response_log (transaction_id, response,	rec_crt_date) VALUES ('".addslashes($client_transaction_id)."', '".base64_encode(addslashes($xmlrs))."', '".addslashes(date('y-m-d H:i:s'))."')";
                        mysqli_query($conn, $sqlResponse);
                    }

                    //Insert log in script executed record table
                    $insert_qry = "INSERT INTO t_bkn_script_txn (client_transaction_id, payment_id, payment_gateway_response, updated_status) VALUES('".$client_transaction_id."', '".$payment_id."', '".$payment_data_res."', '".$update_status."')";
                    mysqli_query($conn, $insert_qry);
                }
            }
        }
    }
}

fwrite($fp, "\n");
fwrite($fp, '=================================================================');

fclose($fp);

?>
<center><h3 style="color: green;">Script Executed, Please wait for 10 seconds before closing the browser tab</h3></center>