<?php
    $gameContent = getContent('game.content',true);
    $games = \App\Models\Game::where('status',1)->get(['image','name','id','max_limit','min_limit','win','invest_back','alias']);
?>
<!-- game section start -->
<section class="pt-120 pb-120 section--bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="section-header text-center">
                    <h2 class="section-title"><?php echo e(__($gameContent->data_values->heading)); ?></h2>
                    <p class="mt-3"><?php echo e(__($gameContent->data_values->sub_heading)); ?></p>
                </div>
            </div>
        </div>
        <div class="row justify-content-center mb-none-30">
            <?php $__empty_1 = true; $__currentLoopData = $games; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $game): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="col-xl-3 col-lg-4 col-sm-6 mb-30 wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">
                    <div class="game-card">
                        <div class="game-card__thumb">
                            <img src="<?php echo e(getImage(imagePath()['game']['path'].'/'.$game->image,imagePath()['game']['size'])); ?>" alt="image">
                        </div>
                        <div class="game-card__content">
                            <h4 class="game-name"><?php echo e(__($game->name)); ?></h4>
                            <a href="<?php echo e(route('user.play.'.$game->alias)); ?>" class="cmn-btn d-block text-center btn-sm mt-3 btn--capsule"><?php echo app('translator')->get('Play Now'); ?></a>
                        </div>
                    </div>
                    <!-- game-card end -->
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <?php echo app('translator')->get('No Data Found!'); ?>
            <?php endif; ?>
        </div>
    </div>
</section>
<!-- game section end -->
<?php /**PATH /home/liv4casino/public_html/core/resources/views/templates/basic/sections/game.blade.php ENDPATH**/ ?>