<?php $__env->startSection('content'); ?>
    <!-- account section start -->
    <?php
        $loginContent = getContent('login.content',true);
    ?>
    <section class="login-section bg_img" style="background-image: url( <?php echo e(getImage('assets/images/frontend/login/' . @$loginContent->data_values->image, '1920x1280')); ?> );">
        <div class="login-area">
            <div class="login-area-inner">
                <div class="text-center">
                    <a class="site-logo mb-4" href="<?php echo e(route('home')); ?>"><img
                            src="<?php echo e(asset('assets/images/logoIcon/logo.png')); ?>" alt="site-logo"></a>
                    <h2 class="title mb-2"><?php echo e(__($loginContent->data_values->title)); ?></h2>
                    <p><?php echo e(__($loginContent->data_values->sub_title)); ?></p>
                </div>
                <form method="POST" action="<?php echo e(route('user.login')); ?>" onsubmit="return submitUserForm();" class="login-form mt-50">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <label><?php echo app('translator')->get('Username or Email'); ?></label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <div class="input-group-text"><i class="las la-user"></i></div>
                            </div>
                            <input type="text" class="form-control" value="<?php echo e(old('username')); ?>" name="username" placeholder="<?php echo app('translator')->get('Username or Email'); ?>">
                        </div>
                    </div><!-- form-group end -->
                    <div class="form-group">
                        <label><?php echo app('translator')->get('Password'); ?></label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <div class="input-group-text"><i class="las la-key"></i></div>
                            </div>
                            <input type="password" class="form-control" name="password" placeholder="<?php echo app('translator')->get('Password'); ?>">
                        </div>
                    </div><!-- form-group end -->

                    <div class="d-flex justify-content-center mb-3">
                        <?php echo loadReCaptcha() ?>
                    </div>

                    <?php echo $__env->make($activeTemplate.'partials.custom_captcha', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <div class="mt-5">
                        <button type="submit" class="cmn-btn rounded-0 w-100"><?php echo app('translator')->get('Login Now'); ?></button>
                        <div class="mt-20 d-flex flex-wrap justify-content-between">
                            <p><?php echo app('translator')->get("Haven't an account?"); ?> <a href="<?php echo e(route('user.register')); ?>"  class="text--base"><?php echo app('translator')->get('Create an account'); ?></a></p>
                            <p><a href="<?php echo e(route('user.password.request')); ?>"  class="text--base"><?php echo app('translator')->get('Forget password?'); ?></a></p>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>
    <!-- account section end -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        function submitUserForm() {
            var response = grecaptcha.getResponse();
            if (response.length == 0) {
                document.getElementById('g-recaptcha-error').innerHTML = '<span class="text-danger"><?php echo app('translator')->get("Captcha field is required."); ?></span>';
                return false;
            }
            return true;
        }

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/liv4casino/public_html/core/resources/views/templates/basic/user/auth/login.blade.php ENDPATH**/ ?>