<?php
    $blogContent = getContent('blog.content',true);
    if (request()->route()->getName() == 'home'){
        $blogElements = getContent('blog.element',false,3);
    } else {
        $blogElements = \App\Models\Frontend::where('data_keys', 'blog.element')->latest('id')->paginate(getPaginate());
    }
?>
<!-- blog section start -->
<section class="pb-120 <?php echo e(request()->route()->getName() != 'home' ? 'pt-120':''); ?>">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="section-header text-center">
                    <h2 class="section-title"><?php echo e(__($blogContent->data_values->heading)); ?></h2>
                    <p class="mt-3"><?php echo e(__($blogContent->data_values->sub_heading)); ?></p>
                </div>
            </div>
        </div>
        <div class="row mb-none-30 justify-content-center">
            <?php $__currentLoopData = $blogElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blogElement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6 mb-30 wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">
                    <div class="post-card">
                        <div class="post-card__thumb">
                            <img
                                src="<?php echo e(getImage('assets/images/frontend/blog/'.@$blogElement->data_values->blog_image,'670x375')); ?>"
                                alt="image">
                                <span class="post-card__date"><?php echo e($blogElement->created_at->format('d M, Y')); ?></span>
                        </div>
                        <div class="post-card__content">
                            <h3 class="post-card__title mt-2 mb-3"><a
                                    href="<?php echo e(route('blog.details',[$blogElement->id,slug($blogElement->data_values->title)])); ?>"><?php echo e(__($blogElement->data_values->title)); ?></a>
                            </h3>
                            <!-- <p><?php echo e(__($blogElement->data_values->preview_text)); ?></p> -->
                            <a href="<?php echo e(route('blog.details',[$blogElement->id,slug($blogElement->data_values->title)])); ?>"
                               class="cmn-btn btn-sm mt-3"><?php echo app('translator')->get('Read More'); ?></a>
                        </div>
                    </div>
                    <!-- post-card end -->
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <?php if(request()->route()->getName() != 'home'): ?>
            <?php echo e($blogElements->links()); ?>

        <?php endif; ?>
    </div>
</section>
<!-- blog section end -->
<?php /**PATH /home/mistikaplay/public_html/core/resources/views/templates/basic/sections/blog.blade.php ENDPATH**/ ?>