<?php
    $testimonialContent = getContent('testimonial.content',true);
    $testimonialElements = getContent('testimonial.element');
?>
<!-- testimonial section start -->
<section class="pt-120 pb-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="section-header text-center">
                    <h2 class="section-title style--two"><?php echo e(__($testimonialContent->data_values->heading)); ?></h2>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="testimonial-slider">
                    <?php $__currentLoopData = $testimonialElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonialElement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="single-slide">
                            <div class="testimonial-card">
                                <div class="testimonial-card__content">
                                    <div class="testimonial-card__content-inner">
                                        <p><?php echo e(__($testimonialElement->data_values->quote)); ?></p>
                                    </div>
                                </div>
                                <div class="testimonial-card__thumb">
                                    <img
                                        src="<?php echo e(getImage('assets/images/frontend/testimonial/'.@$testimonialElement->data_values->person_image,'100x100')); ?>"
                                        alt="image">
                                </div>
                                <h6 class="name mt-2"><?php echo e(__($testimonialElement->data_values->name)); ?></h6>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <!-- testimonial-slider end -->
            </div>
        </div>
    </div>
</section>
<!-- testimonial section end -->
<?php /**PATH /home/liv4casino/public_html/core/resources/views/templates/basic/sections/testimonial.blade.php ENDPATH**/ ?>