<?php $__env->startSection('content'); ?>

    <?php
        $contact_content = getContent('contact_us.content', true);
        $address_content = getContent('address.content', true);
    ?>

<section class="pt-120 pb-120">
    <div class="container pb-120">
        <div class="row justify-content-center">
            <div class="col-lg-12 mb-50">
                <h2 class="font-weight-bold"><?php echo app('translator')->get('Quick Support'); ?></h2>
                <span><?php echo app('translator')->get('You can get all information'); ?></span>
            </div>
            <div class="col-lg-12">
                <div class="row mb-none-30">
                    <div class="col-md-4 col-sm-6 mb-30">
                        <div class="contact-item">
                            <i class="fas fa-phone-alt"></i>
                            <h5 class="mt-2"><?php echo app('translator')->get('Call Us'); ?></h5>
                            <div class="mt-4">
                                <p><a href="tel:<?php echo e(@$address_content->data_values->phone); ?>"><?php echo e(__(@$address_content->data_values->phone)); ?></a></p>
                            </div>
                        </div><!-- contact-item end -->
                    </div>
                    <div class="col-md-4 col-sm-6 mb-30">
                        <div class="contact-item">
                            <i class="fas fa-envelope"></i>
                            <h5 class="mt-2"><?php echo app('translator')->get('Mail Us'); ?></h5>
                            <div class="mt-4">
                                <p><a href="mailto:<?php echo e(@$address_content->data_values->email); ?>"><?php echo e(__(@$address_content->data_values->email)); ?></a></p>
                            </div>
                        </div><!-- contact-item end -->
                    </div>
                    <div class="col-md-4 col-sm-6 mb-30">
                        <div class="contact-item">
                            <i class="fas fa-map-marker-alt"></i>
                            <h5 class="mt-2"><?php echo app('translator')->get('Visit Us'); ?></h5>
                            <div class="mt-4">
                                <p><?php echo e(__(@$address_content->data_values->address)); ?></p>
                            </div>
                        </div><!-- contact-item end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="contact-wrapper">
            <div class="row">
                <div class="col-lg-6 contact-thumb bg_img" style="background-image: url('<?php echo e(getImage('assets/images/frontend/contact_us/' . @$contact_content->data_values->image, '1280x848')); ?>');"></div>
                <div class="col-lg-6 contact-form-wrapper">
                    <h2 class="font-weight-bold"><?php echo e(__(@$contact_content->data_values->title)); ?></h2>
                    <form class="contact-form mt-4" method="post" action="">
                        <?php echo csrf_field(); ?>

                        <div class="form-row">
                            <div class="form-group col-lg-6">
                                <input name="name" type="text" placeholder="<?php echo app('translator')->get('Your Name'); ?>" class="form-control"
                                       value="<?php echo e(auth()->check() ? auth()->user()->fullname : old('name')); ?>" <?php if(auth()->user()): ?> readonly <?php endif; ?> required>
                            </div>
                            <div class="form-group col-lg-6">
                                <input name="email" type="text" placeholder="<?php echo app('translator')->get('Enter E-Mail Address'); ?>" class="form-control"
                                       value="<?php echo e(auth()->check() ? auth()->user()->email : old('email')); ?>" <?php if(auth()->user()): ?> readonly <?php endif; ?> required>
                            </div>
                            <div class="form-group col-lg-12">
                                <input name="subject" type="text" placeholder="<?php echo app('translator')->get('Write your subject'); ?>" class="form-control"
                                       value="<?php echo e(old('subject')); ?>" required>
                            </div>
                            <div class="form-group col-lg-12">
                                <textarea name="message" wrap="off" placeholder="<?php echo app('translator')->get('Write your message'); ?>"
                                          class="form-control"><?php echo e(old('message')); ?></textarea>
                            </div>
                            <div class="col-lg-12">
                                <button type="submit" class="cmn-btn"><?php echo app('translator')->get('Send Message'); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div><!-- contact-wrapper end -->
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/admincrypt/liv4casino.com/core/resources/views/templates/basic/contact.blade.php ENDPATH**/ ?>