<?php $__env->startSection('content'); ?>
    <section class="pb-120 pt-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="account-wrapper">
                        <div class="text-center">
                            <h2 class="title mb-3"><?php echo e(__('Verification Code')); ?></h2>
                        </div>
                        <form action="<?php echo e(route('user.password.verify.code')); ?>" method="POST" class="action-form">
                            <?php echo csrf_field(); ?>

                            <input type="hidden" name="email" value="<?php echo e($email); ?>">

                            <div class="form-group">
                                <input type="text" name="code" id="code" class="form-control">
                            </div>

                            <div class="text-center">
                                <button type="submit" class="cmn-btn"><?php echo app('translator')->get('Verify Code'); ?> <i
                                        class="las la-sign-in-alt"></i></button>
                                <p class="mt-4"><?php echo app('translator')->get('Please check including your Junk/Spam Folder. if not found, you can '); ?>
                                    <a href="<?php echo e(route('user.password.request')); ?>"><?php echo app('translator')->get('Try to send again'); ?></a></p>
                            </div>

                        </form>
                    </div><!-- account-wrapper end -->
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function ($) {
            "use strict";
            $('#code').on('input change', function () {
                var xx = document.getElementById('code').value;
                $(this).val(function (index, value) {
                    value = value.substr(0, 7);
                    return value.replace(/\W/gi, '').replace(/(.{3})/g, '$1 ');
                });
            });
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mistikaplay/public_html/core/resources/views/templates/basic/user/auth/passwords/code_verify.blade.php ENDPATH**/ ?>