<?php $__env->startSection('content'); ?>

    <?php
        $registerContent = getContent('register.content',true);
    ?>
    <section class="registration-section bg_img" style="background-image: url( <?php echo e(getImage('assets/images/frontend/register/' . @$registerContent->data_values->image, '1920x960')); ?> );">
        <div class="registration-area">
            <div class="registration-area-inner">
                <div class="text-center">
                    <a class="site-logo mb-4" href="<?php echo e(route('home')); ?>"><img
                                src="<?php echo e(asset('assets/images/logoIcon/logo.png')); ?>" alt="site-logo"></a>
                    <h2 class="title mb-3"><?php echo e(__(@$registerContent->data_values->title)); ?></h2>
                    <p><?php echo e(__(@$registerContent->data_values->sub_title)); ?></p>
                </div>
                <form action="<?php echo e(route('user.register')); ?>" method="POST" onsubmit="return submitUserForm();" class="mt-4">
                    <div class="row">
                        <?php echo csrf_field(); ?>

                        <?php if(session()->get('reference') != null): ?>
                            <div class="form-group col-md-6">
                                <label for="referenceBy"><?php echo e(__('Reference BY')); ?></label>

                                <div class="input-group ">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><i class="las la-user"></i></div>
                                    </div>
                                    <input type="text" name="referBy" id="referenceBy" class="form-control"
                                            value="<?php echo e(session()->get('reference')); ?>" readonly>
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="form-group col-md-6">
                            <label for="firstname"><?php echo e(__('First Name')); ?></label>
                            <div class="input-group ">
                                <div class="input-group-prepend">
                                    <div class="input-group-text"><i class="las la-user"></i></div>
                                </div>
                                <input id="firstname" type="text" class="form-control" name="firstname"
                                        value="<?php echo e(old('firstname')); ?>" required>
                            </div>
                        </div><!-- form-group end -->
                        <div class="form-group col-md-6">
                            <label for="lastname"><?php echo e(__('Last Name')); ?></label>
                            <div class="input-group ">
                                <div class="input-group-prepend">
                                    <div class="input-group-text"><i class="las la-user"></i></div>
                                </div>
                                <input id="lastname" type="text" class="form-control" name="lastname"
                                        value="<?php echo e(old('lastname')); ?>" required>
                            </div>
                        </div><!-- form-group end -->


                        <div class="form-group col-md-6">
                            <label for="country"><?php echo e(__('Country')); ?></label>
                            <div class="input-group ">
                                <div class="input-group-prepend">
                                    <div class="input-group-text"><i class="las la-globe"></i></div>
                                </div>
                                <select name="country" id="country" class="form-control">
                                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option data-mobile_code="<?php echo e($country->dial_code); ?>" value="<?php echo e($country->country); ?>" data-code="<?php echo e($key); ?>"><?php echo e(__($country->country)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div><!-- form-group end -->

                        <div class="form-group col-md-6">
                            <label for="country"><?php echo e(__('Mobile')); ?></label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">
                                        <span class="input-group-text mobile-code border-0">

                                        </span>
                                        <input type="hidden" name="mobile_code">
                                        <input type="hidden" name="country_code">
                                    </div>
                                </div>
                                <input type="text" name="mobile" id="mobile" value="<?php echo e(old('mobile')); ?>" class="form-control checkUser" placeholder="<?php echo app('translator')->get('Your Phone Number'); ?>">
                            </div>
                            <small class="text-danger mobileExist"></small>
                        </div><!-- form-group end -->

                        <div class="form-group col-md-6">
                            <label for="username"><?php echo e(__('Username')); ?></label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <div class="input-group-text"><i class="las la-user"></i></div>
                                </div>
                                <input id="username" type="text" class="form-control checkUser" name="username" value="<?php echo e(old('username')); ?>" required>
                            </div>
                            <small class="text-danger usernameExist"></small>
                        </div><!-- form-group end -->

                        <div class="form-group col-md-6">
                            <label for="email"><?php echo app('translator')->get('Email address'); ?></label>
                            <div class="input-group ">
                                <div class="input-group-prepend">
                                    <div class="input-group-text"><i class="las la-at"></i></div>
                                </div>
                                <input id="email" type="email" class="form-control" name="email"
                                        value="<?php echo e(old('email')); ?>" required>
                            </div>
                        </div><!-- form-group end -->

                        <div class="form-group hover-input-popup col-md-6">
                            <label for="password"><?php echo app('translator')->get('Password'); ?></label>
                            <div class="input-group ">
                                <div class="input-group-prepend">
                                    <div class="input-group-text"><i class="las la-key"></i></div>
                                </div>
                                <input id="password" type="password" class="form-control" name="password" required>
                            </div>
                            <?php if($general->secure_password): ?>
                                <div class="input-popup">
                                    <p class="error lower"><?php echo app('translator')->get('1 small letter minimum'); ?></p>
                                    <p class="error capital"><?php echo app('translator')->get('1 capital letter minimum'); ?></p>
                                    <p class="error number"><?php echo app('translator')->get('1 number minimum'); ?></p>
                                    <p class="error special"><?php echo app('translator')->get('1 special character minimum'); ?></p>
                                    <p class="error minimum"><?php echo app('translator')->get('6 character password'); ?></p>
                                </div>
                            <?php endif; ?>
                        </div><!-- form-group end -->

                        <div class="form-group col-md-6">
                            <label for="password-confirm"><?php echo app('translator')->get('Confirm Password'); ?></label>
                            <div class="input-group ">
                                <div class="input-group-prepend">
                                    <div class="input-group-text"><i class="las la-key"></i></div>
                                </div>
                                <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                            </div>
                        </div><!-- form-group end -->

                        <div class="d-flex justify-content-center w-100 mb-3">
                            <?php echo loadReCaptcha() ?>
                        </div>
                        
                        <?php echo $__env->make($activeTemplate.'partials.custom_captcha', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <?php if($general->agree): ?>
                            <?php
                                $extra_pages = getContent('extra.element');
                            ?>
                            <div class="form-group col-md-6 d-flex align-items-start">
                                <input type="checkbox" id="agree" name="agree" class="custom_checkbox">&nbsp;
                                <label for="agree"><?php echo app('translator')->get('I agree with'); ?>
                                    <?php $__empty_1 = true; $__currentLoopData = $extra_pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <a href="<?php echo e(route('extra.details', [$item->id, @slug($item->data_values->title)])); ?>"><?php echo e(__(@$item->data_values->title)); ?></a> <?php echo e($loop->last ? '' : ','); ?>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                                    <?php endif; ?>
                                </label>
                            </div>
                        <?php endif; ?>

                        <div class="mt-3 text-center col-md-12">
                            <button type="submit" class="cmn-btn rounded-0 w-100"><?php echo app('translator')->get('Register'); ?></button>
                            <p class="mt-20"><?php echo app('translator')->get('Already i have an account in here'); ?> <a href="<?php echo e(route('user.login')); ?>" class="text--base"><?php echo app('translator')->get('Login'); ?></a></p>
                        </div>
                    </div>
                </form>
            </div>
        </div><!-- account-wrapper end -->
    </section>

<div class="modal fade" id="existModalCenter" tabindex="-1" role="dialog" aria-labelledby="existModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="existModalLongTitle"><?php echo app('translator')->get('You are with us'); ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <h6 class="text-center"><?php echo app('translator')->get('You already have an account please Sign in '); ?></h6>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
        <a href="<?php echo e(route('user.login')); ?>" class="btn btn-primary"><?php echo app('translator')->get('Login'); ?></a>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
<style>
    .country-code .input-group-prepend .input-group-text{
        background: #fff !important;
    }
    .country-code select{
        border: none;
    }
    .country-code select:focus{
        border: none;
        outline: none;
    }
    .hover-input-popup {
        position: relative;
    }
    .hover-input-popup:hover .input-popup {
        opacity: 1;
        visibility: visible;
    }
    .input-popup {
        position: absolute;
        bottom: 65%;
        left: 50%;
        width: 280px;
        background-color: #1a1a1a;
        color: #fff;
        padding: 20px;
        border-radius: 5px;
        -webkit-border-radius: 5px;
        -moz-border-radius: 5px;
        -ms-border-radius: 5px;
        -o-border-radius: 5px;
        -webkit-transform: translateX(-50%);
        -ms-transform: translateX(-50%);
        transform: translateX(-50%);
        opacity: 0;
        visibility: hidden;
        -webkit-transition: all 0.3s;
        -o-transition: all 0.3s;
        transition: all 0.3s;
    }
    .input-popup::after {
        position: absolute;
        content: '';
        bottom: -19px;
        left: 50%;
        margin-left: -5px;
        border-width: 10px 10px 10px 10px;
        border-style: solid;
        border-color: transparent transparent #1a1a1a transparent;
        -webkit-transform: rotate(180deg);
        -ms-transform: rotate(180deg);
        transform: rotate(180deg);
    }
    .input-popup p {
        padding-left: 20px;
        position: relative;
    }
    .input-popup p::before {
        position: absolute;
        content: '';
        font-family: 'Line Awesome Free';
        font-weight: 900;
        left: 0;
        top: 4px;
        line-height: 1;
        font-size: 18px;
    }
    .input-popup p.error {
        text-decoration: line-through;
    }
    .input-popup p.error::before {
        content: "\f057";
        color: #ea5455;
    }
    .input-popup p.success::before {
        content: "\f058";
        color: #28c76f;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script-lib'); ?>
<script src="<?php echo e(asset('assets/global/js/secure_password.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script>
      "use strict";
        function submitUserForm() {
            var response = grecaptcha.getResponse();
            if (response.length == 0) {
                document.getElementById('g-recaptcha-error').innerHTML = '<span class="text-danger"><?php echo app('translator')->get("Captcha field is required."); ?></span>';
                return false;
            }
            return true;
        }
        (function ($) {
            <?php if($mobile_code): ?>
            $(`option[data-code=<?php echo e($mobile_code); ?>]`).attr('selected','');
            <?php endif; ?>

            $('select[name=country]').change(function(){
                $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
                $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
                $('.mobile-code').text('+'+$('select[name=country] :selected').data('mobile_code'));
            });
            $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
            $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
            $('.mobile-code').text('+'+$('select[name=country] :selected').data('mobile_code'));
            <?php if($general->secure_password): ?>
                $('input[name=password]').on('input',function(){
                    secure_password($(this));
                });
            <?php endif; ?>

            $('.checkUser').on('focusout',function(e){
                var url = '<?php echo e(route('user.checkUser')); ?>';
                var value = $(this).val();
                var token = '<?php echo e(csrf_token()); ?>';
                if ($(this).attr('name') == 'mobile') {
                    var mobile = `${$('.mobile-code').text().substr(1)}${value}`;
                    var data = {mobile:mobile,_token:token}
                }
                if ($(this).attr('name') == 'email') {
                    var data = {email:value,_token:token}
                }
                if ($(this).attr('name') == 'username') {
                    var data = {username:value,_token:token}
                }
                $.post(url,data,function(response) {
                  if (response['data'] && response['type'] == 'email') {
                    $('#existModalCenter').modal('show');
                  }else if(response['data'] != null){
                    $(`.${response['type']}Exist`).text(`${response['type']} already exist`);
                  }else{
                    $(`.${response['type']}Exist`).text('');
                  }
                });
            });


        })(jQuery);

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/liv4casino/public_html/core/resources/views/templates/basic/user/auth/register.blade.php ENDPATH**/ ?>