<?php $__env->startSection('content'); ?>
    <div class="container pt-120 pb-120">
        <div class="row justify-content-center">
            <div class="col-lg-6 col-md-6">
                <?php if(Auth::user()->ts): ?>
                    <div class="card">
                        <div class="card-header text-center">
                            <h3 class="card-title"><?php echo app('translator')->get('Disable 2-factor authenticator'); ?></h3>
                        </div>
                        <div class="card-body">
                            <div class="form-group mx-auto text-center">
                                <a href="#0"  class="btn btn-block btn-lg btn-danger" data-toggle="modal" data-target="#disableModal">
                                    <?php echo app('translator')->get('Disable Two Factor Authenticator'); ?></a>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="card">
                        <div class="card-body p-4">
                            <h3 class="card-title"><?php echo app('translator')->get('Setup 2-factor authenticator'); ?></h3>
                            <p>Scan the image below with the two-factor authentication app. If don't have an scan application <a class="text--base f-size--14" href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&hl=en" target="_blank"><?php echo app('translator')->get('DOWNLOAD APP'); ?></a>. if you can't use a enter this text code instead.</p>
                            <div class="form-group mx-auto text-center mt-5">
                                <img class="mx-auto" src="<?php echo e($qrCodeUrl); ?>">
                            </div>
                            <div class="form-group">
                                <div class="input-group">
                                    <input type="text" name="key" value="<?php echo e($secret); ?>" class="form-control form-control-lg" id="referralURL" readonly>
                                    <div class="input-group-append">
                                        <span class="input-group-text copytext border-secondary" id="copyBoard" onclick="myFunction()"> <i class="fa fa-copy"></i> </span>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group mx-auto text-center">
                                <a href="#0" class="cmn-btn btn-block" data-toggle="modal" data-target="#enableModal"><?php echo app('translator')->get('Enable Two Factor Authenticator'); ?></a>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>



    <!--Enable Modal -->
    <div id="enableModal" class="modal fade" role="dialog">
        <div class="modal-dialog ">
            <!-- Modal content-->
            <div class="modal-content section--bg">
                <div class="modal-header">
                    <h4 class="modal-title"><?php echo app('translator')->get('Verify Your Otp'); ?></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form action="<?php echo e(route('user.twofactor.enable')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body ">
                        <div class="form-group">
                            <input type="hidden" name="key" value="<?php echo e($secret); ?>">
                            <input type="text" class="form-control" name="code" placeholder="<?php echo app('translator')->get('Enter Google Authenticator Code'); ?>">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo app('translator')->get('close'); ?></button>
                        <button type="submit" class="btn base--bg"><?php echo app('translator')->get('Verify'); ?></button>
                    </div>
                </form>
            </div>

        </div>
    </div>

    <!--Disable Modal -->
    <div id="disableModal" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content section--bg">
                <div class="modal-header">
                    <h4 class="modal-title"><?php echo app('translator')->get('Verify Your Otp Disable'); ?></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form action="<?php echo e(route('user.twofactor.disable')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <input type="text" class="form-control" name="code" placeholder="<?php echo app('translator')->get('Enter Google Authenticator Code'); ?>">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo app('translator')->get('close'); ?></button>
                        <button type="submit" class="btn base--bg"><?php echo app('translator')->get('Verify'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";

        function myFunction() {
            var copyText = document.getElementById("referralURL");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            /*For mobile devices*/
            document.execCommand("copy");
            iziToast.success({message: "Copied: " + copyText.value, position: "topRight"});
        }
    </script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mistikaplay/public_html/core/resources/views/templates/basic/user/twofactor.blade.php ENDPATH**/ ?>