<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require "./EnvLoader.php";

$envLoader = new EnvLoader(".env");

$envLoader->load();

require "./Siquro.php";



$siquro = new Siquro();


// Setting essential data for integration
$first_name = "Ratnesh";
$last_name = "Karbhari";
$full_name = $first_name." ".$last_name;
$credit_card_number = 4444333322221111;
$expiryMonth = "09";
$expiryYear = 23;
$cvv = 123;
$ipAddress = "8.8.8.8";
$amount = 4;
$email = "ratneshkarbhari18@gmail.com";
$amountInSubunits = $amount * 100;
$productTitle = "Product Title";
$brandId = getenv("BRAND_ID");

$purchaseRequestArray = [

  "client" => [
    "email" => $email
  ],
  "purchase" => [
    "products" => [
      [
        "name" => $productTitle,
        "price" => $amountInSubunits
      ]
    ]
  ],
  "brand_id" => $brandId,
  "success_redirect" => "https://google.com",
  "failure_redirect" => "https://facebook.com"
];

$purchaseRequestJson = json_encode($purchaseRequestArray);

$purchaseResponseJson = $siquro->create_purchase($purchaseRequestJson);

$purchaseResponseObj = json_decode($purchaseResponseJson, TRUE);


$direct_post_url =  $purchaseResponseObj["direct_post_url"];

$s2sObj = [
  "cardholder_name" => $full_name,
  "card_number"=> $credit_card_number,
  "expires"=> $expiryMonth."/".$expiryYear,
  "cvc"=> $cvv,
  "remember_card"=> "on",
  "remote_ip"=> $ipAddress,
  "user_agent"=> $_SERVER['HTTP_USER_AGENT'],
  "accept_header"=> "text/html",
  "language"=> "en-US",
  "java_enabled"=> false,
  "javascript_enabled"=> true,
  "color_depth"=> 24,
  "utc_offset"=> 0,
  "screen_width"=> 1920,
  "screen_height"=> 1080
];

$s2sJson = json_encode($s2sObj);

echo $s2sResponse = $siquro->execute_s2s($direct_post_url,$s2sJson);