<!doctype html>
<html lang="en" itemscope itemtype="http://schema.org/WebPage">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title> <?php echo e($general->sitename(__($pageTitle))); ?></title>
    <?php echo $__env->make('partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/line-awesome.min.css')); ?>">

    <!-- bootstrap 4  -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/bootstrap.min.css')); ?>">
    <!-- image and videos view on page plugin -->
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'/css/lightcase.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'/css/vendor/animate.min.css')); ?>">
    <!-- custom select css -->
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'/css/vendor/nice-select.css')); ?>">
    <!-- slick slider css -->
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'/css/vendor/slick.css')); ?>">
    <!-- dashdoard main css -->
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'/css/main.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/bootstrap-fileinput.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/custom.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/color.php?color='.$general->base_color)); ?>">

    <?php echo $__env->yieldPushContent('style-lib'); ?>

    <?php echo $__env->yieldPushContent('style'); ?>
</head>
<body>

<?php echo $__env->yieldPushContent('fbComment'); ?>

<div class="preloader">
    <div class="preloader__inner">
        <div class="preloader__thumb">
            <img src="<?php echo e(asset('assets/images/logoIcon/logo.png')); ?>" alt="imge" class="mt-3 loaderLogo">
            <img src="<?php echo e(asset($activeTemplateTrue.'/images/preloader-dice.png')); ?>" alt="image" class="loadercircle">
        </div>
    </div>
</div>

<div class="page-wrapper" id="main-scrollbar" data-scrollbar>
    <!-- header-section start  -->
    <header class="header">
        <div class="header__bottom">
            <div class="container">
                <nav class="navbar navbar-expand-xl p-0 align-items-center">
                    <a class="site-logo site-title" href="<?php echo e(route('home')); ?>"><img
                            src="<?php echo e(asset('assets/images/logoIcon/logo.png')); ?>" alt="site-logo"></a>
                    <button class="navbar-toggler ml-auto" type="button" data-toggle="collapse"
                            data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                            aria-expanded="false" aria-label="Toggle navigation">
                        <span class="menu-toggle"></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav main-menu m-auto">
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('Home')); ?></a></li>
                            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a href="<?php echo e(route('pages',[$data->slug])); ?>"><?php echo e(__($data->name)); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <li><a href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a></li>
                        </ul>
                        <div class="nav-right">
                            <?php if(auth()->guard()->check()): ?>
                                <a href="<?php echo e(route('user.home')); ?>"><i
                                        class="las la-tachometer-alt"></i> <?php echo app('translator')->get('Dashboard'); ?></a>
                                <a href="<?php echo e(route('user.logout')); ?>"><i class="las la-sign-out-alt"></i> <?php echo app('translator')->get('Logout'); ?>
                                </a>
                            <?php else: ?>
                                <a href="<?php echo e(route('user.login')); ?>"><i class="las la-sign-in-alt"></i> <?php echo app('translator')->get('Login'); ?>
                                </a>
                                <a href="<?php echo e(route('user.register')); ?>"><i
                                        class="las la-user-plus"></i> <?php echo app('translator')->get('Registration'); ?></a>
                            <?php endif; ?>
                            <select class="langSel">
                                <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->code); ?>"
                                            <?php if(session('lang') == $item->code): ?> selected <?php endif; ?>><?php echo e(__($item->name)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </header>
    <!-- header-section end  -->

    <!--breadcrumb area-->
<?php if(request()->route()->getName() != 'home'): ?>
    <?php echo $__env->make($activeTemplate.'partials.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>
<!--/breadcrumb area-->

<?php echo $__env->yieldContent('content'); ?>


<?php
    $footer_contents = getContent('footer.content', true);
    $footer_elements = getContent('footer.element');
    $address_content = getContent('address.content', true);
    $extra_pages = getContent('extra.element');
    $blog_elements = getContent('blog.element',false,3);

    $methodContent = getContent('payment_method.content',true);
    $methodElements = getContent('payment_method.element');
?>


<!-- scroll-to-top start -->
<div class="scroll-to-top">
    <span class="scroll-icon">
        <i class="las la-arrow-up"></i>
    </span>
</div>
<!-- scroll-to-top end -->

<!-- footer section start -->
    <footer class="footer-section">
        <div class="payment-area">
            <div class="container border-bottom pb-5">
                <div class="row">
                    <div class="col-xl-12 text-center">
                        <h3><?php echo e(__($methodContent->data_values->heading)); ?></h3>
                    </div>
                    <div class="col-xl-12 mt-4">
                        <div class="payment-slider">
                            <?php $__currentLoopData = $methodElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $methodElement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="single-slide">
                                    <div class="payment-item">
                                    <img src="<?php echo e(getImage('assets/images/frontend/payment_method/'.@$methodElement->data_values->method_image)); ?>" alt="image">
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-top">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-4 col-md-6 text-md-left text-center">
                        <div class="footer-widget">
                            <a href="<?php echo e(route('home')); ?>" class="footer-logo mb-4">
                                <img src="<?php echo e(getImage(imagePath()['logoIcon']['path'] .'/logo.png')); ?>" alt="image">
                            </a>
                        </div>
                        <!-- footer-widget end -->
                    </div>
                    <div class="col-lg-8 col-md-6">
                        <div class="footer-widget">
                            <ul class="footer-menu justify-content-md-end justify-content-center">
                                <?php $__empty_1 = true; $__currentLoopData = $extra_pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <li>
                                        <a href="<?php echo e(route('extra.details', [$item->id, @slug($item->data_values->title)])); ?>"><?php echo e(__(@$item->data_values->title)); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <!-- footer-widget end -->
                    </div>
                </div>
            </div>
        </div>
        <!-- footer-top end -->
        <div class="footer-bottom">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-6 text-md-left text-center order-lg-1 order-2">
                        <p>This website is managed and operated by MISTIKA DATA S.A., registered number 3-101-853355, with address at City of San Jose, Central, Hospital Avenida segunda Oficentro Centro Colon piso número 2, Costa Rica. Gambling can be addictive. Play responsibly.
© All Rights Reserved, 2022 18+ <span class="base--color"><?php echo e(@$general->sitename); ?></span></p>
                    </div>
                    <div class="col-lg-6 col-md-6 mt-md-0 mt-3 order-lg-3 order-3">
                        <ul class="footer-social-links d-flex flex-wrap align-items-center justify-content-md-end justify-content-center">
                            <li><a href="#0"><i class="lab la-facebook-f"></i></a></li>
                            <li><a href="#0"><i class="lab la-twitter"></i></a></li>
                            <li><a href="#0"><i class="lab la-pinterest-p"></i></a></li>
                            <li><a href="#0"><i class="lab la-linkedin-in"></i></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- footer section end -->

    <?php
        $cookie = App\Models\Frontend::where('data_keys','cookie.data')->first();
    ?>
    <?php if(@$cookie->data_values->status && !session('cookie_accepted')): ?>
        <div class="cookie__wrapper">
            <div class="container">
                <div class="d-flex flex-wrap align-items-center justify-content-between">
                    <p class="txt my-2">
                        <?php echo @$cookie->data_values->description ?>
                        <a href="<?php echo e(@$cookie->data_values->link); ?>" target="_blank" class="text--base"><?php echo app('translator')->get('Read Policy'); ?></a>
                    </p>
                    <button class="cmn-btn btn-md my-2 acceptPolicy"><?php echo app('translator')->get('Accept'); ?></button>
                </div>
            </div>
        </div>
    <?php endif; ?>

</div>
<!-- page-wrapper end -->

<!-- Optional JavaScript -->
<!-- jQuery first, then Popper.js, then Bootstrap JS -->
<script src="<?php echo e(asset('assets/global/js/jquery-3.6.0.min.js')); ?>"></script>
<!-- bootstrap js -->
<script src="<?php echo e(asset('assets/global/js/bootstrap.bundle.min.js')); ?>"></script>
<!-- lightcase plugin -->
<script src="<?php echo e(asset($activeTemplateTrue.'/js/vendor/lightcase.js')); ?>"></script>
<!-- custom select js -->
<script src="<?php echo e(asset($activeTemplateTrue.'/js/vendor/jquery.nice-select.min.js')); ?>"></script>
<!-- slick slider js -->
<script src="<?php echo e(asset($activeTemplateTrue.'/js/vendor/slick.min.js')); ?>"></script>
<!-- scroll animation -->
<script src="<?php echo e(asset($activeTemplateTrue.'/js/vendor/wow.min.js')); ?>"></script>
<!-- dashboard custom js -->
<script src="<?php echo e(asset($activeTemplateTrue.'/js/app.js')); ?>"></script>

<?php echo $__env->yieldPushContent('script-lib'); ?>

<?php echo $__env->yieldPushContent('script'); ?>

<?php echo $__env->make('partials.plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('partials.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
    (function ($) {
        "use strict";

        $(document).on("change", ".langSel", function () {
            window.location.href = "<?php echo e(url('/')); ?>/change/" + $(this).val();

        });

        //Cookie
        $(document).on('click', '.acceptPolicy', function () {
            $.ajax({
                url: "<?php echo e(route('cookie.accept')); ?>",
                method:'GET',
                success:function(data){
                    if (data.success){
                        $('.cookie__wrapper').addClass('d-none');
                        notify('success', data.success)
                    }
                },
            });
        });

        //Subscribe
        $(document).on('submit', '.subscribe-form', function (e) {

            e.preventDefault();

            var url = '<?php echo e(route("subscribe")); ?>';
            var data = $(this).serialize();
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: url,
                method: "POST",
                data: data,
                success: function (data) {
                    if (data.success) {
                        notify('success', data.message);
                        $('.subscribe-form').trigger('reset');
                    }

                    if (data.errors) {
                        notify('error', data.errors);
                    }
                },
            });
        });
    })(jQuery);

</script>

</body>
</html>
<?php /**PATH /home/mistikaplay/public_html/core/resources/views/templates/basic/layouts/frontend.blade.php ENDPATH**/ ?>