<?php $__env->startSection('content'); ?>
    <section class="pt-120 pb-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header card-header-bg d-flex flex-wrap justify-content-between align-items-center">
                            <h5 class="card-title mt-0">
                                <?php if($my_ticket->status == 0): ?>
                                    <span class="badge badge--success"><?php echo app('translator')->get('Open'); ?></span>
                                <?php elseif($my_ticket->status == 1): ?>
                                    <span class="badge badge--primary"><?php echo app('translator')->get('Answered'); ?></span>
                                <?php elseif($my_ticket->status == 2): ?>
                                    <span class="badge badge--warning"><?php echo app('translator')->get('Replied'); ?></span>
                                <?php elseif($my_ticket->status == 3): ?>
                                    <span class="badge badge--dark"><?php echo app('translator')->get('Closed'); ?></span>
                                <?php endif; ?>
                                [<?php echo app('translator')->get('Ticket'); ?>#<?php echo e($my_ticket->ticket); ?>] <?php echo e($my_ticket->subject); ?>

                            </h5>
                            <button class="btn btn-danger close-button" type="button" title="<?php echo app('translator')->get('Close Ticket'); ?>"
                                    data-toggle="modal" data-target="#DelModal"><i class="las la-times-circle"></i>
                            </button>
                        </div>
                        <div class="card-body">
                            <?php if($my_ticket->status != 4): ?>
                                <form method="post" action="<?php echo e(route('ticket.reply', $my_ticket->id)); ?>"
                                        enctype="multipart/form-data" class="mb-4">
                                    <?php echo csrf_field(); ?>
                                    <div class="row justify-content-between">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <textarea name="message"
                                                            class="form-control"
                                                            id="inputMessage"
                                                            placeholder="<?php echo app('translator')->get('Your Reply'); ?>" rows="4"
                                                            cols="10"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row justify-content-between">
                                        <div class="col-md-8">
                                            <div class="row justify-content-between">
                                                <div class="col-md-11">

                                                    <div class="form-group">
                                                        <div class="position-relative">
                                                            <input type="file" name="attachments[]"
                                                                    id="inputAttachments"
                                                                    class="form-control custom--file-upload my-1"/>
                                                            <label
                                                                for="inputAttachments"><?php echo app('translator')->get('Attachments'); ?></label>
                                                        </div>
                                                        <p class="my-2 ticket-attachments-message text-muted">
                                                            <?php echo app('translator')->get("Allowed File Extensions: .jpg, .jpeg, .png, .pdf"); ?>
                                                        </p>
                                                        <div id="fileUploadsContainer"></div>
                                                    </div>

                                                </div>
                                                <div class="col-md-1">
                                                    <div class="form-group">
                                                        <a href="javascript:void(0)"
                                                            class="base--bg add-btn addFile">
                                                            <i class="las la-plus"></i>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <button type="submit"
                                                    class="cmn-btn custom-success"
                                                    name="replayTicket" value="1">
                                                <i class="fa fa-reply"></i> <?php echo app('translator')->get('Reply'); ?>
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            <?php endif; ?>

                            <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($message->admin_id == 0): ?>
                                    <div
                                        class="single-reply">
                                        <div class="left">
                                            <h5><?php echo e($message->ticket->name); ?></h5>
                                        </div>
                                        <div class="right">
                                            <p class="mb-2 text--base f-size--14">
                                                <?php echo app('translator')->get('Posted on'); ?> <?php echo e($message->created_at->format('l, dS F Y @ H:i')); ?></p>
                                            <p><?php echo e($message->message); ?></p>
                                            <?php if($message->attachments()->count() > 0): ?>
                                                <div class="mt-2">
                                                    <?php $__currentLoopData = $message->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=> $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <a href="<?php echo e(route('ticket.download',encrypt($image->id))); ?>"
                                                            class="mr-3"><i
                                                                class="fa fa-file"></i> <?php echo app('translator')->get('Attachment'); ?> <?php echo e(++$k); ?>

                                                        </a>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div
                                        class="single-reply"
                                        style="background-color: #ffd96729">
                                        <div class="left">
                                            <h5><?php echo e($message->admin->name); ?></h5>
                                            <p>(<?php echo app('translator')->get('Staff'); ?>)</p>
                                        </div>
                                        <div class="right">
                                            <p class="mb-2 text--base f-size--14">
                                                <?php echo app('translator')->get('Posted on'); ?> <?php echo e($message->created_at->format('l, dS F Y @ H:i')); ?></p>
                                            <p><?php echo e($message->message); ?></p>
                                            <?php if($message->attachments()->count() > 0): ?>
                                                <div class="mt-2">
                                                    <?php $__currentLoopData = $message->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=> $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <a href="<?php echo e(route('ticket.download',encrypt($image->id))); ?>"
                                                            class="mr-3"><i
                                                                class="fa fa-file"></i> <?php echo app('translator')->get('Attachment'); ?> <?php echo e(++$k); ?>

                                                        </a>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <div class="modal fade" id="DelModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content section--bg">

                <form method="post" action="<?php echo e(route('ticket.reply', $my_ticket->id)); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="modal-header">
                        <h5 class="modal-title"> <?php echo app('translator')->get('Confirmation'); ?>!</h5>

                        <button type="button" class="close close-button" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="modal-body">
                        <?php echo app('translator')->get('Are you sure you want to Close This Support Ticket'); ?>?
                    </div>
                    <div class="modal-footer">

                        <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i
                                class="fa fa-times"></i>
                            <?php echo app('translator')->get('Close'); ?>
                        </button>

                        <button type="submit" class="btn base--bg btn-sm" name="replayTicket"
                                value="2"><i class="fa fa-check"></i> <?php echo app('translator')->get("Confirm"); ?>
                        </button>
                    </div>

                </form>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function ($) {
            "use strict";
            $('.delete-message').on('click', function (e) {
                $('.message_id').val($(this).data('id'));
            });
            $('.addFile').on('click', function () {
                $("#fileUploadsContainer").append(`<div class="position-relative mb-2">
                                                        <input type="file" name="attachments[]" id="inputAttachments" class="form-control custom--file-upload my-1"/>
                                                        <label for="inputAttachments"><?php echo app('translator')->get('Attachments'); ?></label>
                                                    </div>`)
            });
        })(jQuery);

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mistikaplay/public_html/core/resources/views/templates/basic/user/support/view.blade.php ENDPATH**/ ?>