<?php $__env->startSection('content'); ?>

    <section class="pt-120 pb-120">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="card-body h-100 middle-el">
                        <div class="cd-ft"></div>
                        <div class="game-details-left">
                            <div class="game-details-left__body">
                                <div class="spin-card">
                                    <div class="wheel-wrapper">
                                        <div class="arrow text-center">
                                            <img src="<?php echo e(asset($activeTemplateTrue .'images/play/down.png')); ?>"
                                                 height="50"
                                                 width="50">
                                        </div>
                                        <div class="wheel text-center the_wheel">
                                            <canvas id="canvas" width="434" height="434" class="w-100">
                                                <p class="text-white"
                                                   align="center"><?php echo app('translator')->get("Sorry, your browser doesn't support canvas. Please try another."); ?></p>
                                            </canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 mt-lg-0 mt-5">
                    <div class="game-details-right">
                        <form method="post" id="game">
                            <?php echo csrf_field(); ?>
                            <h3 class="mb-4 text-center f-size--28"><?php echo app('translator')->get('Current Balance'); ?> : <span class="base--color"><span
                                        class="bal"><?php echo e(__(getAmount(auth()->user()->balance))); ?></span> <?php echo e(__($general->cur_text)); ?></span>
                            </h3>
                            <div class="form-group">
                                <div class="input-group mb-3">
                                    <input type="text" name="invest" class="form-control amount-field"
                                           placeholder="Enter amount">
                                    <div class="input-group-append">
                                        <span class="input-group-text"
                                              id="basic-addon2"><?php echo e(__($general->cur_text)); ?></span>
                                    </div>
                                </div>
                                <small class="form-text text-muted"><i
                                        class="fas fa-info-circle mr-2"></i> <?php echo app('translator')->get('Minimum :'); ?> <?php echo e($game->min_limit +0); ?> <?php echo e($general->cur_text); ?>

                                    | <?php echo app('translator')->get('Maximum :'); ?> <?php echo e(getAmount($game->max_limit+0)); ?> <?php echo e(__($general->cur_text)); ?>

                                    | <span
                                        class="text-warning"> <?php echo app('translator')->get('Win Amount'); ?> <?php if($game->invest_back == 1): ?><?php echo e(getAmount($game->win+100)); ?> <?php else: ?> <?php echo e(getAmount($game->win)); ?> <?php endif; ?> <?php echo app('translator')->get('%'); ?> </span></small>
                            </div>
                            <div class="form-group mt-5 justify-content-center d-flex">
                                <div class="single-select black gmimg">
                                    <img src="<?php echo e(asset($activeTemplateTrue.'images/play/moneyblack.png')); ?>"
                                         alt="game-image">
                                </div>
                                <div class="single-select red gmimg">
                                    <img src="<?php echo e(asset($activeTemplateTrue.'images/play/money.png')); ?>"
                                         alt="game-image">
                                </div>
                            </div>
                            <input type="hidden" name="choose">
                            <div class="mt-5 text-center">
                                <button type="submit" class="cmn-btn w-100 text-center"><?php echo app('translator')->get('Play Now'); ?></button>
                                <a data-toggle="modal" data-target="#exampleModalCenter"
                                   class="mt-1 btn btn-link"><?php echo app('translator')->get('Game Instruction'); ?> <i
                                        class="las la-info-circle"></i></a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <audio id="pop">
        <source src="<?php echo e(asset($activeTemplateTrue.'audio/spinWheel.mp3')); ?>" type="audio/mpeg">
    </audio>

    <!-- Modal -->
    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog"
         aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content section--bg">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle"><?php echo app('translator')->get('Game Rule'); ?></h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <?php echo __($game->instruction) ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <style type="text/css">
        .the_wheel {
            max-width: 450px;
        }

        @media (max-width: 425px) {
            .game-details-left {
                display: -ms-flexbox;
                display: flex;
                -ms-flex-wrap: wrap;
                flex-wrap: wrap;
                justify-content: center;
                align-items: center;
                padding: 20px;
            }
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset($activeTemplateTrue .'js/TweenMax.min.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue .'js/Winwheel.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue .'js/spinFunctions.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        "use strict";

        $('input[name=invest]').keypress(function (e) {
            var character = String.fromCharCode(e.keyCode)
            var newValue = this.value + character;
            if (isNaN(newValue) || hasDecimalPlace(newValue, 3)) {
                e.preventDefault();
                return false;
            }
        });

        function hasDecimalPlace(value, x) {
            var pointIndex = value.indexOf('.');
            return pointIndex >= 0 && pointIndex < value.length - x;
        }

        $('#game').on('submit', function (e) {
            e.preventDefault();
            beforeProcess();
            var data = $(this).serialize();
            var url = '<?php echo e(route("user.play.playspinWheel")); ?>';
            game(url, data);
        });

        function endGame(data) {
            var url = '<?php echo e(route("user.play.gameEndSpinWheel")); ?>'
            complete(data, url)
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mistikaplay/public_html/core/resources/views/templates/basic/user/games/spinWheel.blade.php ENDPATH**/ ?>