<?php $__env->startSection('content'); ?>
    <div class="container pt-120 pb-120">
        <div class="row justify-content-center">

            <?php $__currentLoopData = $withdrawMethod; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <div class="col-lg-3 col-md-5 col-sm-12 mb-4">
                    <div class="card card-withdraw">
                        <h5 class="card-header text-center mt-3 pb-0"><?php echo e(__($data->name)); ?></h5>
                        <div class="card-body card-body-withdraw">
                            <img src="<?php echo e(getImage(imagePath()['withdraw']['method']['path'].'/'. $data->image,imagePath()['withdraw']['method']['size'])); ?>" class="card-img-top" alt="<?php echo e(__($data->name)); ?>" class="w-100">
                            <ul class="list-group text-center">
                                <li class="list-group-item bg-transparent pb-0"><?php echo app('translator')->get('Limit'); ?>
                                    : <?php echo e(getAmount($data->min_limit)); ?>

                                    - <?php echo e(getAmount($data->max_limit)); ?> <?php echo e(__($general->cur_text)); ?></li>

                                <li class="list-group-item bg-transparent p-0"> <?php echo app('translator')->get('Charge'); ?>
                                    : <?php echo e(getAmount($data->fixed_charge)); ?> <?php echo e(__($general->cur_text)); ?>

                                    + <?php echo e(getAmount($data->percent_charge)); ?>%
                                </li>
                                <li class="list-group-item bg-transparent pt-0"><?php echo app('translator')->get('Processing Time'); ?>
                                    :<br> <?php echo e($data->delay); ?></li>
                            </ul>
                        </div>
                        <div class="card-footer">
                            <a href="javascript:void(0)"  data-id="<?php echo e($data->id); ?>"
                               data-resource="<?php echo e($data); ?>"
                               data-min_amount="<?php echo e(getAmount($data->min_limit)); ?>"
                               data-max_amount="<?php echo e(getAmount($data->max_limit)); ?>"
                               data-fix_charge="<?php echo e(getAmount($data->fixed_charge)); ?>"
                               data-percent_charge="<?php echo e(getAmount($data->percent_charge)); ?>"
                               data-base_symbol="<?php echo e(__($general->cur_text)); ?>"
                               class="btn cmn-btn btn-block withdraw" data-toggle="modal" data-target="#withdrawModal">
                                <?php echo app('translator')->get('Withdraw Now'); ?></a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>


    <!-- Modal -->
    <div class="modal fade" id="withdrawModal" tabindex="-1" role="dialog" aria-labelledby="withdrawModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content section--bg">
                <div class="modal-header">
                    <h5 class="modal-title method-name" id="withdrawModalLabel"><?php echo app('translator')->get('Withdraw'); ?></h5>
                    <button type="button" class="close  text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('user.withdraw.money')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <p class="text-danger withdrawLimit"></p>
                        <p class="text-danger withdrawCharge"></p>

                        <div class="form-group">
                            <input type="hidden" name="currency"  class="edit-currency form-control">
                            <input type="hidden" name="method_code" class="edit-method-code  form-control">
                        </div>



                        <div class="form-group">
                            <label><?php echo app('translator')->get('Enter Amount'); ?>:</label>
                            <div class="input-group">
                                <input id="amount" type="text" class="form-control form-control-lg" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" name="amount" placeholder="0.00" required=""  value="<?php echo e(old('amount')); ?>">

                                <div class="input-group-append">
                                    <span class="input-group-text addon-bg currency-addon"><?php echo e(__($general->cur_text)); ?></span>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn base--bg"><?php echo app('translator')->get('Confirm'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        (function ($) {
            "use strict";
            $('.withdraw').on('click', function () {
                var id = $(this).data('id');
                var result = $(this).data('resource');
                var minAmount = $(this).data('min_amount');
                var maxAmount = $(this).data('max_amount');
                var fixCharge = $(this).data('fix_charge');
                var percentCharge = $(this).data('percent_charge');

                var withdrawLimit = `<?php echo app('translator')->get('Withdraw Limit'); ?>: ${minAmount} - ${maxAmount}  <?php echo e(__($general->cur_text)); ?>`;
                $('.withdrawLimit').text(withdrawLimit);
                var withdrawCharge = `<?php echo app('translator')->get('Charge'); ?>: ${fixCharge} <?php echo e(__($general->cur_text)); ?> ${(0 < percentCharge) ? ' + ' + percentCharge + ' %' : ''}`
                $('.withdrawCharge').text(withdrawCharge);
                $('.method-name').text(`<?php echo app('translator')->get('Withdraw Via'); ?> ${result.name}`);
                $('.edit-currency').val(result.currency);
                $('.edit-method-code').val(result.id);
            });
        })(jQuery);
    </script>

<?php $__env->stopPush(); ?>


<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/admincrypt/liv4casino.com/core/resources/views/templates/basic/user/withdraw/methods.blade.php ENDPATH**/ ?>