<?php $__env->startSection('content'); ?>
    <section class="pt-120 pb-120">
        <div class="container">
            <div class="row justify-content-center">

                <?php $__currentLoopData = $gatewayCurrency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-3 col-md-5 col-sm-12 mb-4">
                        <div class="p-method-card">
                            <div class="thumb">
                                <img src="<?php echo e($data->methodImage()); ?>" class="card-img-top w-100" alt="<?php echo e($data->name); ?>">
                            </div>
                            <div class="content">
                                <ul class="p-method-card-list text-center mt-4">
                                    <li>
                                        <?php echo e(__($data->name)); ?></li>
                                    <!--<li><?php echo app('translator')->get('Limit'); ?>-->
                                    <!--    : <?php echo e(getAmount($data->min_amount)); ?>-->
                                    <!--    - <?php echo e(getAmount($data->max_amount)); ?> <?php echo e($general->cur_text); ?></li>-->
                                    <li> <?php echo app('translator')->get('Charge'); ?>
                                        - <?php echo e(getAmount($data->fixed_charge)); ?> <?php echo e($general->cur_text); ?>

                                        + <?php echo e(getAmount($data->percent_charge)); ?>%
                                    </li>
                                    <li>
                                        <button type="button"  data-id="<?php echo e($data->id); ?>" data-resource="<?php echo e($data); ?>"
                                                data-base_symbol="<?php echo e($data->baseSymbol()); ?>"
                                                class=" btn btn-md deposit p-method-card-btn  w-100 mt-3" data-toggle="modal" data-target="#exampleModal">
                                            <?php echo app('translator')->get('Deposit'); ?></button>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>



    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content section--bg">
                <div class="modal-header">
                    <h6 class="modal-title method-name" id="exampleModalLabel"></h6>
                    <a href="javascript:void(0)" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </a>
                </div>
                <form action="<?php echo e(route('user.deposit.insert')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <input type="hidden" name="currency" class="edit-currency" value="">
                            <input type="hidden" name="method_code" class="edit-method-code" value="">
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Enter Amount'); ?>:</label>
                            <div class="input-group">
                                <input id="amount" type="text" class="form-control form-control-lg" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" name="amount" placeholder="0.00" required  value="<?php echo e(old('amount')); ?>">
                                <div class="input-group-append">
                                    <span class="input-group-text currency-addon addon-bg"><?php echo e($general->cur_text); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn base--bg"><?php echo app('translator')->get('Confirm'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function(){
            "use strict";
            $('.deposit').on('click', function () {
                var id = $(this).data('id');
                var result = $(this).data('resource');
                var minAmount = $(this).data('min_amount');
                var maxAmount = $(this).data('max_amount');
                var baseSymbol = "<?php echo e($general->cur_text); ?>";
                var fixCharge = $(this).data('fix_charge');
                var percentCharge = $(this).data('percent_charge');

                var depositLimit = `<?php echo app('translator')->get('Deposit Limit:'); ?> ${minAmount} - ${maxAmount}  ${baseSymbol}`;
                $('.depositLimit').text(depositLimit);
                var depositCharge = `<?php echo app('translator')->get('Charge:'); ?> ${fixCharge} ${baseSymbol}  ${(0 < percentCharge) ? ' + ' +percentCharge + ' % ' : ''}`;
                $('.depositCharge').text(depositCharge);
                $('.method-name').text(`<?php echo app('translator')->get('Payment By'); ?> ${result.name}`);
                $('.currency-addon').text(baseSymbol);


                $('.edit-currency').val(result.currency);
                $('.edit-method-code').val(result.method_code);
            });
        });
    </script>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('style'); ?>
<style type="text/css">

</style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mistikaplay/public_html/core/resources/views/templates/basic/user/payment/deposit.blade.php ENDPATH**/ ?>