<?php

namespace App\Http\Controllers\Gateway\Damapay;

use App\Models\Deposit;
use App\Models\GeneralSetting;
use App\Http\Controllers\Gateway\PaymentController;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;


// require './Spoynt.php';

class ProcessController extends Controller
{

    /*
     * Spoynt Gateway
     */
    public static function process($deposit)
    {
        
        

        $depositJson = json_encode($deposit);
        
        $depositArray = json_decode($depositJson,TRUE);
        

        $userId = $depositArray["user_id"];
        $txAmt = round($depositArray["final_amo"],2);
        
        $currency = $depositArray["method_currency"];
        $depositId = $depositArray["id"];
        
        $user = DB::table('users')->find($userId);
        
        $first_name = $user->firstname;        
        $last_name = $user->lastname;
        $email = $user->email;

        $data = new Deposit();
        $data->user_id = $user->id;
        $data->method_code = $depositArray["method_code"];
        $data->method_currency = $currency;
        $data->amount = $depositArray["amount"];
        $data->charge = $depositArray["charge"];
        $data->rate = $depositArray["rate"];
        $data->final_amo = $txAmt;
        $data->btc_amo = 0;
        $data->btc_wallet = "";
        $data->trx = getTrx();
        $data->try = 0;
        $data->status = 0;      
        $data->save();


        $data = array(
            "title" => "Damapay Payment",
            "user" => $user,
            "user_id" => $userId,
            "first_name" => $first_name,
            "last_name" => $last_name,
            
            "email" => $email,
            "amount" => $txAmt,
            "currency" => $currency,
            "deposit_id" => $depositId,
            "success_url" => "https://mistikaplay.com/damapay/return.php"
        );
        $send['redirect'] = false;
        // $send['redirect_url'] = $res->payment_request->longurl;
        
        echo view('templates.basic.user.payment.damapay', $data);


        exit;
    }
}