<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1.0, shrink-to-fit=no">
<link href="../assests/images/favicon.png" rel="icon" />
<title>Documentation | LivtnumApi</title>
<meta name="description" content="LivtnumApi">
<meta name="author" content="Rahul">

<!-- Stylesheet
============================== -->
<!-- Bootstrap -->
<link rel="stylesheet" type="text/css" href="../assests//vendor/bootstrap/css/bootstrap.min.css" />
<!-- Font Awesome Icon -->
<link rel="stylesheet" type="text/css" href="../assests/vendor/font-awesome/css/all.min.css" />
<!-- Magnific Popup -->
<link rel="stylesheet" type="text/css" href="../assests/vendor/magnific-popup/magnific-popup.min.css" />
<!-- Highlight Syntax -->
<link rel="stylesheet" type="text/css" href="../assests/vendor/highlight.js/styles/github.css" />
<!-- Custom Stylesheet -->
<link rel="stylesheet" type="text/css" href="../assests/css/stylesheet.css" />
</head>

<body data-spy="scroll" data-target=".idocs-navigation" data-offset="125">

<!-- Preloader -->
<div class="preloader">
  <div class="lds-ellipsis">
    <div></div>
    <div></div>
    <div></div>
    <div></div>
  </div>
</div>
<!-- Preloader End --> 

<!-- Document Wrapper   
=============================== -->
<div id="main-wrapper"> 
  
  <!-- Header
  ============================ -->
  <header id="header" class="sticky-top"> 
    <!-- Navbar -->
    <nav class="primary-menu navbar navbar-expand-lg bg-dark navbar-text-light navbar-dropdown-dark border-0">
      <div class="container-fluid">
        <!-- Sidebar Toggler -->
		<button id="sidebarCollapse" class="navbar-toggler d-block d-md-none" type="button"><span></span><span class="w-75"></span><span class="w-50"></span></button>
		
		<!-- Logo --> 
        <p>LivtnumApi <span class="text-2 text-light ml-2">v1.0</span> </p> 
		
        <!-- Logo End -->
        
		<!-- Navbar Toggler -->
		<button class="navbar-toggler ml-auto" type="button" data-toggle="collapse" data-target="#header-nav"><span></span><span></span><span></span></button>
        
		<div id="header-nav" class="collapse navbar-collapse justify-content-end">
          <ul class="navbar-nav">
            <!--li class="dropdown"> <a class="dropdown-toggle" href="#">Dropdown</a>
              <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="#">Action</a></li>
                <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Dropdown Action</a>
                  <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="index.html">Action</a></li>
                    <li><a class="dropdown-item" href="feature-header-dark.html">Another Action</a></li>
                    <li><a class="dropdown-item" href="feature-header-primary.html">Something Else Here</a></li>
                    <li><a class="dropdown-item" href="index-2.html">Another Link</a></li>
                  </ul>
                </li>
                <li><a class="dropdown-item" href="#">Another Action</a>
                <li><a class="dropdown-item" href="#">Something Else Here</a></li>
              </ul>
            </li-->
            <li>User Name</li>
            <!--li><a target="_blank" href="#">Support</a></li-->
          </ul>
        </div>
        <!--ul class="social-icons social-icons-sm ml-lg-2 mr-2">
          <li class="social-icons-twitter"><a data-toggle="tooltip" href="http://www.twitter.com/harnishdesign/" target="_blank" title="" data-original-title="Twitter"><i class="fab fa-twitter"></i></a></li>
          <li class="social-icons-facebook"><a data-toggle="tooltip" href="http://www.facebook.com/harnishdesign/" target="_blank" title="" data-original-title="Facebook"><i class="fab fa-facebook-f"></i></a></li>
          <li class="social-icons-dribbble"><a data-toggle="tooltip" href="http://www.dribbble.com/harnishdesign/" target="_blank" title="" data-original-title="Dribbble"><i class="fab fa-dribbble"></i></a></li>
        </ul-->
      </div>
    </nav>
    <!-- Navbar End --> 
  </header>
  <!-- Header End --> 
  
  <!-- Content
  ============================ -->
  <div id="content" role="main">
    
	<!-- Sidebar Navigation
	============================ -->
	<div class="idocs-navigation bg-light">
      <ul class="nav flex-column ">
        <li class="nav-item"><a class="nav-link active" href="#idocs_start">Getting Started</a>
          <ul class="nav flex-column">
            <li class="nav-item"><a class="nav-link" href="#idocs_installation">Introduction</a></li>
            <li class="nav-item"><a class="nav-link" href="#idocs_html_structure">HTML Structure</a></li>
            <li class="nav-item"><a class="nav-link" href="#idocs_form">HTML Form</a></li>
            <!--li class="nav-item"><a class="nav-link" href="#idocs_color_schemes">Color Schemes</a></li>
            <li class="nav-item"><a class="nav-link" href="#idocs_theme_customization">Customization</a></li>
            <li class="nav-item"><a class="nav-link" href="#idocs_logo_settings">Logo Settings</a></li-->
          </ul>
        </li>
        <!--li class="nav-item"><a class="nav-link" href="#idocs_layout">Layout</a>
          <ul class="nav flex-column">
			<li class="nav-item"><a class="nav-link" href="#idocs_header">Header</a></li>
			<li class="nav-item"><a class="nav-link" href="#idocs_navbar">Navbar</a></li>
			<li class="nav-item"><a class="nav-link" href="#idocs_sidebar">Sidebar</a></li>
			<li class="nav-item"><a class="nav-link" href="#idocs_footer">Footer</a></li>
			<li class="nav-item"><a class="nav-link" href="#idocs_box_layout">Box Layout</a></li>
          </ul>
        </li-->
        
            <!--li class="nav-item"><a class="nav-link" href="#idocs_typography">Typography</a></li-->
            <li class="nav-item"><a class="nav-link" href="#idocs_code">Request Sample</a></li>
            <li class="nav-item"><a class="nav-link" href="#idocs_pdf">ApI PDF</a></li>
			<!--li class="nav-item"><a class="nav-link" href="#idocs_icons">Icons</a></li>
            <li class="nav-item"><a class="nav-link" href="#idocs_image">Image</a></li>
			<li class="nav-item"><a class="nav-link" href="#idocs_video">Video</a></li-->
         
        
		<!--li class="nav-item"><a class="nav-link" href="#idocs_faq">FAQ</a></li-->
        <!--li class="nav-item"><a class="nav-link" href="#idocs_source_credits">Source & Credits</a></li-->
        <!--li class="nav-item"><a class="nav-link" href="#idocs_support">Support</a></li-->
		<!--li class="nav-item"><a class="nav-link" href="#idocs_templates">More Templates</a></li>
		<li class="nav-item"><a class="nav-link" href="#idocs_changelog">Changelog</a>
			<ul class="nav flex-column">
            <li class="nav-item"><a class="nav-link" href="#v1-1">v1.1</a></li>
            <li class="nav-item"><a class="nav-link" href="#v1-0">v1.0</a></li>
          </ul>
		</li-->
      </ul>
    </div>
    
    <!-- Docs Content
	============================ -->
    <div class="idocs-content">
      <div class="container"> 
        
        <!-- Getting Started
		============================ -->
        <section id="idocs_start">
        <h1>Documentation</h1>
        <h2>LivtnumApi</h2>
        <p class="lead">Indian Payment Gateway .</p>
		<hr>
		<div class="row">
			<div class="col-sm-6 col-lg-4">
				<ul class="list-unstyled">
					<li><strong>Version:</strong> 1.0</li>
					<li><strong>Author:</strong> <a href="#" target="_blank">Rahul Kumar</a></li>
				</ul>
			</div>
			<div class="col-sm-6 col-lg-4">
				<ul class="list-unstyled">
					<li><strong class="font-weight-700">Created:</strong> 24 Aug, 2023</li>
					<li><strong>Update:</strong> 25 Aug, 2023</li>
				</ul>
			</div>
		</div>
        <p class="alert alert-info">If you have any questions that are beyond the scope of this help file, Please feel free to email via <bold style="color:red">Support Email</bold>.</p>
        </section>
        
		<hr class="divider">
		
        <!-- Installation
		============================ -->
        <section id="idocs_installation">
          <h2>Introduction</h2>
           <p></p>
		<hr class="divider">
		
        <!-- HTML Structure
		============================ -->
        <section id="idocs_html_structure">
          <h2>HTML Structure</h2>
          <div class="table-responsive">
            <table class="table">
              <thead><tr><th>Field Name</th><th>Field Type</th><th>Example</th></tr></thead>
            </table>
          </div>
          
          </section>

		<hr class="divider">
		<section id="idocs_form">
      <h3>Form Request Sample</h3>   
    <pre> 
&lt;form id="PaymentForm" action="https://true8.in/api/lp/mobikwik/pay.php"method="POST"&gt;
&lt;input type="hidden" name="transaction_id" value="398760" /&gt;
&lt;input type="hidden" name="first_name" value="Rahu" /&gt;
&lt;input type="hidden" name="last_name" value="Singh" //&gt;
&lt;input type="hidden" name="phoneNum" value="9110188610" /&gt;
&lt;input type="hidden" name="billAddress" value="Kolkata,West Bengal " /&gt;
&lt;input type="hidden" name="billAddress2" value="Ludvig strasse 23 -2" /&gt;
&lt;input type="hidden" name="billStreet" value="Ludvig strasse" /&gt;
&lt;input type="hidden" name="billCountry" value="IN" /&gt;
&lt;input type="hidden" name="billState" value="WB" /&gt;
&lt;input type="hidden" name="billZip" value="10969" /&gt;
&lt;input type="hidden" name="billCity" value="Kolkata" /&gt;
&lt;input type="hidden" name="ipn" value="LIVITPAYTESTID" /&gt;
&lt;input type="hidden" name="amount" value="5" /&gt;
&lt;input type="hidden" name="currency" value="13" /&gt;
&lt;input type="hidden" name="email" value="rahu@gmail.com" /&gt;
&lt;input type="hidden" name="ipAddress" value="**********" /&gt;
&lt;input type="hidden" name="callback_url" value="https://webhook.site/3987" /&gt;
&lt;input type="hidden" name="redirect_url" value="www.google.com" /&gt;
&lt;/form&gt;
</pre>
   
    </section>
        
		<hr class="divider">
		
		<!-- Layout
		============================ -->
        	<section id="idocs_code">
		  <h2>Request Sample Code</h2>
      <code>
        <p class="hc"> Preparing the variables</p></br>
  $code="$first_name=$_POST['first_name']; <br/>
$last_name=$_POST['last_name']; <br/>
$email=$_POST['email']; <br/>
$phoneNum=$_POST['contact']; <br/>
$billAddress=$_POST['address']; <br/>
$address1=$_POST['address1']; <br/>
$billCountry=$_POST['country']; <br/>
$billState=$_POST['state']; <br/>
$billCity=$_POST['city']; <br/>
$billZip=$_POST['zip']; <br/>
$amount=$_POST['amount']; <br/>
$currency=$_POST[‘currency’]; <br/>
$transaction_id = 'Your Unique Transaction Id For each Transaction'; <br/>
$callback_url = 'URL of your Server where you would receive the Call Back Response'; <br/>
$redirect_url = 'URL of your Server where you would want to redirect after the completion of the Transaction'; <br/>
$ipn='IPN Provided to you';
$url='API END POINT URL where you would send the data';
$ip_address='Customer Browser IP address (dynamic)';
 <hr>
 <p class="hc">Preparing the data string to send tot he Api End Point</p></br>
 $postdata="transaction_id=".$transaction_id."&amount=".$amount."&email=".$email."&first_name=".$first_name.
"&last_name=".$last_name."&phoneNum=".$phoneNum."&billCountry=".$billCountry."&billState=".$billState."&billCity=".$billCity.
"&billAddress=".$billAddress."&billZip=".$billZip."&ipn=".$ipn."&callback_url=".$callback_url."&redirect_url=".$success_url.
"&exp_month=".$exp_month."&cvv=".$cvv."&card_no=".$card_no."&exp_year=".$exp_year;
<hr>
<p class="hc">Sending the data</p>

$ch = curl_init();
curl_setopt ($ch, CURLOPT_URL, $url);
curl_setopt ($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
curl_setopt ($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.6) Gecko/20070725 Firefox/2.0.0.6");
curl_setopt ($ch, CURLOPT_TIMEOUT, 60);
curl_setopt ($ch, CURLOPT_FOLLOWLOCATION, 0);
curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt ($ch, CURLOPT_REFERER, $url);
curl_setopt ($ch, CURLOPT_POSTFIELDS, $postdata);
curl_setopt ($ch, CURLOPT_POST, 1);
$result = curl_exec ($ch);
echo $result;
print_r($result);
curl_close($ch);

      </code>
          </section>
          <hr class="divider"><br>
          <section id="idocs_pdf">
            <h5>Kindly click to download the APi doc PDF file</h5>
            <hr class="divider">
            <div class="row">
              <div class="col-md-3">
               1
              </div>
              <div class="col-md-3">
                2
              </div>
              <div class="col-md-3">
                3
              </div>
              <div class="col-md-3">
                4
              </div>
            </div>
          </section>
		  <hr class="divider">
		
		<!-- FAQ
		============================ -->
		
		<!-- Support
		============================ -->
        		
				
		<!-- More Templates
		============================ -->
       
		<!--hr class="divider"-->
		
        <!-- Changelog
		============================ -->
		
       
          
		  <h3 id="v1-1">Version 1.1 <small class="text-muted">(20 Aug, 2023)</small></h3>
         
		  <!--hr class="divider"-->
		  
          <h3 id="v1-0">Version 1.0 <small class="text-muted">(10 April, 20222)</small></h3>
          <p>Initial Release</p>
        </section>       
      </div>
    </div>
	
  </div>
  <!-- Content end --> 
  
  <!-- Footer
  ============================ -->
  <footer id="footer" class="section bg-dark footer-text-light">
    <div class="container">
      
      <p class="text-center">Copyright &copy; 2023<a href="https://livttnuapi.com">LivvtnuApi</a>. All Rights Reserved.</p>
	 </div>
  </footer>
  <!-- Footer end -->
  
</div>
<!-- Document Wrapper end --> 

<!-- Back To Top --> 
<a id="back-to-top" data-toggle="tooltip" title="Back to Top" href="javascript:void(0)"><i class="fa fa-chevron-up"></i></a> 

<!-- JavaScript
============================ -->
<script src="../assests/vendor/jquery/jquery.min.js"></script> 
<script src="../assests/vendor/bootstrap/js/bootstrap.bundle.min.js"></script> 
<!-- Highlight JS -->
<script src="../assests/vendor/highlight.js/highlight.min.js"></script> 
<!-- Easing --> 
<script src="../assests/vendor/jquery.easing/jquery.easing.min.js"></script> 
<!-- Magnific Popup --> 
<script src="../assests/vendor/magnific-popup/jquery.magnific-popup.min.js"></script> 
<!-- Custom Script -->
<script src="../assests/js/theme.js"></script>
</body>
</html>
