<?php
/**
 * WP Ultimate CSV Importer plugin file.
 *
 * Copyright (C) 2010-2020, Smackcoders Inc - info@smackcoders.com
 */

namespace Smackcoders\FCSV;

if ( ! defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly

class MetaBoxImport {
    private static $metabox_instance = null, $media_instance;

    public static function getInstance() {
		
		if (MetaBoxImport::$metabox_instance == null) {
			MetaBoxImport::$metabox_instance = new MetaBoxImport;
			MetaBoxImport::$media_instance = new MediaHandling();
			return MetaBoxImport::$metabox_instance;
		}
		return MetaBoxImport::$metabox_instance;
    }
	
    function set_metabox_values($header_array ,$value_array , $map, $post_id , $type){
		
		$post_values = [];
		$helpers_instance = ImportHelpers::getInstance();	
		$post_values = $helpers_instance->get_header_values($map , $header_array , $value_array);
		
		$this->metabox_import_function($post_values, $post_id , $header_array , $value_array, $type);
    }

    public function metabox_import_function ($data_array, $pID, $header_array, $value_array, $type) {
		
		global $wpdb;
		$helpers_instance = ImportHelpers::getInstance();
		$media_instance = MediaHandling::getInstance();
		$extension_object = new ExtensionHandler;
		$import_as = $extension_object->import_post_types($type );

		$get_metabox_fields = \rwmb_get_object_fields( $import_as ); 

		foreach($data_array as $data_key => $data_value){
			$field_type = $get_metabox_fields[$data_key]['type'];
			$check_for_multiple = isset($get_metabox_fields[$data_key]['multiple']) ? $get_metabox_fields[$data_key]['multiple'] : '';

			if($field_type == 'text_list' || $field_type == 'select' || $field_type == 'select_advanced'){
				$get_text_list_fields = explode(',', $data_value);
				foreach($get_text_list_fields as $text_list_fields){
					if($check_for_multiple){
						add_post_meta($pID, $data_key, $text_list_fields);
					}
					else{
						update_post_meta($pID, $data_key, $text_list_fields);
					}
				}
			}
			elseif($field_type == 'checkbox_list'){
				$get_checkbox_list_fields = explode(',', $data_value);
				foreach($get_checkbox_list_fields as $checkbox_list_fields){
					add_post_meta($pID, $data_key, $checkbox_list_fields);
				}
			}
			elseif($field_type == 'fieldset_text'){
				$get_fieldset_text_fields = explode(',', $data_value);
				$get_fieldset_options = $get_metabox_fields[$data_key]['options'];

				$temp = 0;
				$fieldset_array = [];
				foreach($get_fieldset_options as $fieldset_key => $fieldset_options){
					$fieldset_array[$fieldset_key] = $get_fieldset_text_fields[$temp];
					$temp++;
				}
		
				update_post_meta($pID, $data_key, $fieldset_array);
			}
			elseif($field_type == 'image' || $field_type == 'file' || $field_type == 'file_advanced' || $field_type == 'image_advanced'){
				$get_uploads_fields = explode(',', $data_value);
				$get_fields_count = count($get_uploads_fields);

				foreach($get_uploads_fields as $uploads_fields){
					$attachmentId = MetaBoxImport::$media_instance->media_handling($uploads_fields, $pID);
					
					if($get_fields_count > 1){
						add_post_meta($pID, $data_key, $attachmentId);	
					}
					else{
						update_post_meta($pID, $data_key, $attachmentId);	
					}
				}	
			}
			elseif($field_type == 'file_input'){
				$attachmentId = MetaBoxImport::$media_instance->media_handling($data_value, $pID);
					
				$get_file_url = $wpdb->get_var("SELECT guid FROM {$wpdb->prefix}posts WHERE post_type = 'attachment' AND ID = $attachmentId");
				update_post_meta($pID, $data_key, $get_file_url);
			}
			elseif($field_type == 'password'){
				$data_value = wp_hash_password($data_value);
				update_post_meta($pID, $data_key, $data_value);
			}
			elseif($field_type == 'post' || $field_type == 'user' || $field_type == 'taxonomy'){
				if(is_numeric($data_value)){
					update_post_meta($pID, $data_key, $data_value);
				}
				else{
					if($field_type == 'post'){
						$get_post_id = $wpdb->get_var("SELECT ID FROM {$wpdb->prefix}posts WHERE post_title = '$data_value' AND post_status != 'trash' ");
					}
					elseif($field_type == 'user'){
						$get_post_id = $wpdb->get_var("SELECT ID FROM {$wpdb->prefix}users WHERE user_login = '$data_value' ");
					}
					elseif($field_type == 'taxonomy'){
						$get_post_id = $wpdb->get_var("SELECT term_id FROM {$wpdb->prefix}terms WHERE name = '$data_value' ");
					}
					update_post_meta($pID, $data_key, $get_post_id);
				}	
			}
			$listTaxonomy = get_taxonomies();
			if($data_array){
				if($type == 'Users'){
					foreach($data_array as $data_key => $data_value){
						update_user_meta($pID,$data_key,$data_value);
					}
				}
				
				elseif(in_array($type, $listTaxonomy)){
					foreach($data_array as $data_key => $data_value){
						update_term_meta($pID,$data_key,$data_value);
					}
				}
				else{
					foreach($data_array as $data_key => $data_value){
						update_post_meta($pID,$data_key,$data_value);
					}
				}
			}
			else{
				update_post_meta($pID, $data_key, $data_value);
			}
		}
	}
}