<?php
$load_status = !empty($_GET['status']) ? $_GET['status'] : '';
$this->load->view('header'); ?>

<style>
    .redClass {
        background-color: #FFD2D2;
    }

    .dangerCustom {
        background-color: #F81717;
        font-weight: bold;
        color: #A1A19C;
    }

    .processCustom {
        background-color: #ecec13;
        font-weight: bold;
        color: #A1A19C;
    }

    .successCustom {
        background-color: #3F7A05;
        font-weight: bold;
        color: #A1A19C;
    }

    .tot {
        margin: 1px;
    }

    .form-inline .form-group {
        display: block;
    }

    .form-inline .form-control {
        display: block;
        width: 100%;
    }

    .form-group .btn {
        width: 100%;
    }

    .row div {
        margin-top: 10px;
        margin-bottom: 10px;
    }

    .dataTables_paginate a {
        cursor: pointer;
        margin-right: 5px;
        background: #910c0c !important;
        border-color: #910c0c !important;
        color: #fff !important;
    }

    #overlay {
        position: fixed;
        top: 0;
        z-index: 100;
        width: 100%;
        height: 100%;
        display: none;
        background: rgba(0, 0, 0, 0.6);
        left: 0;
    }

    .cv-spinner {
        height: 100%;
        display: flex;
        justify-content: right;
    }

    .spinner {
        width: 40px;
        height: 40px;
        border: 4px #ddd solid;
        border-top: 4px #2e93e6 solid;
        border-radius: 50%;
        animation: sp-anime 0.8s infinite linear;
    }

    @keyframes sp-anime {
        100% {
            transform: rotate(360deg);
        }
    }

    .is-hide {
        display: none;
    }

    .panel-body {
        box-shadow: none;
        padding-top: 0px !important;
    }

    .table-condensed>tbody>tr>td,
    .table-condensed>tbody>tr>th,
    .table-condensed>tfoot>tr>td,
    .table-condensed>tfoot>tr>th,
    .table-condensed>thead>tr>td,
    .table-condensed>thead>tr>th {
        max-width: 100px !important;
        word-wrap: break-word !important;
    }

    #gateway_data_modal .modal-body {
        max-height: 450px;
        overflow-y: scroll;
    }

    @media only screen and (max-width: 576px) and (min-width: 320px){
        div.dataTables_wrapper {
            width: calc(100vw - 50px);
            overflow-x: scroll;
        }
        .dataTables_paginate{
            float: none;
            text-align: center;
        }
        .dataTables_paginate a{
            margin-right: unset;
        }
        .dataTables_info{
            width: 100%;
            margin-bottom: 15px !important;
            text-align: center;
        }
        .datatable_div{
            margin-right: auto !important;
            margin-left: auto !important;
        }
    }
</style>

<link href="https://bo.xpy.tech/application/views/sales/jquery.dataTables.min.css" />

<br />

<br />

<div id="overlay">
    <div class="cv-spinner">
        <span class="spinner"></span>
    </div>
</div>

<form class="form-inline" role="form" name="frmSearch" id="frmSearch"
    action="<?php echo base_url() . $this->controllerFile; ?>index_old" method="POST">
    <div class="row">
        <div class="col-md-3 col-xs-6">
            <div class="form-group">
                <label class="form-label sr-only" for="exampleInputEmail2">Start date</label>
                <input type="text" id="datepiker" name="start_date" placeholder="Start date" value=""
                    class="dp form-control" autocomplete="off">
            </div>
        </div>

        <div class="col-md-3 col-xs-6">
            <div class="form-group">
                <label class="sr-only" for="exampleInputEmail2">End date</label>
                <input type="text" id="datepiker1" name="end_date" placeholder="End date" value=""
                    class="dp form-control" autocomplete="off">
            </div>
        </div>

        <?php if ($_SESSION['ADMIN_TYPE'] == 'superadmin') { ?>
            <div class="col-md-3 col-xs-6">
                <div class="form-group">
                    <label class="sr-only" for="timepicker">Start Time</label>
                    <input type="time" id="timepicker" data-toggle="tooltip" title="Start time" name="start_time"
                        placeholder="Start Time" value="<?php echo $start_time; ?>" class="dp form-control" />
                </div>
            </div>

            <div class="col-md-3 col-xs-6">
                <div class="form-group">
                    <label class="sr-only" for="timepicker1">End Time</label>
                    <input type="time" id="timepicker1" data-toggle="tooltip" title="End Time" name="end_time"
                        placeholder="End Time" value="<?php echo $end_time; ?>" class="dp form-control" />
                </div>
            </div>
        <?php } ?>

        <?php if ($_SESSION['ADMIN_LEVEL'] == 'System') { ?>
            <div class="col-md-3 col-xs-6">
                <div class="form-group">
                    <label class="sr-only" for="exampleInputEmail2">IPN</label>
                    <select name="selected_ipn" class="form-control" id="selected_ipn">
                        <option value="">Select IPN</option>
                    </select>
                </div>
            </div>
        <?php } ?>


        <?php if ($_SESSION['ADMIN_LEVEL'] == 'System') { ?>
        <div class="col-md-3 col-xs-6">
            <div class="form-group">
                <input type="text" id="order_id" name="order_id" placeholder="Order ID" value="<?php echo $order_id; ?>"
                    class="form-control">
            </div>
        </div>
        <?php } ?>

        <?php if ($_SESSION['ADMIN_LEVEL'] == 'System') { ?>
        <div class="col-md-3 col-xs-6">
            <div class="form-group">
                <input type="text" id="gatewayTransactionId" name="gatewayTransactionId"
                    placeholder="Gateway Transaction ID" value="" class="form-control">
            </div>
        </div>
        <?php } ?>

        <?php if ($_SESSION['ADMIN_LEVEL'] == 'System') { ?>
        <div class="col-md-3 col-xs-6">
            <div class="form-group">
                <label class="sr-only" for="exampleInputEmail2">gateway</label>
                <select name="g_type" class="form-control" id="g_type">
                    <option value="">Select Gateway</option>
                </select>
            </div>
        </div>
        <?php } ?>

        <?php if ($_SESSION['ADMIN_LEVEL'] == 'System') { ?>
        <div class="col-md-3 col-xs-6">
            <div class="form-group">
                <select name="currency_type" id="currency_type" class="form-control">
                    <option value="">Select Currency</option>
                    <option value="EUR">EUR</option>
                    <option value="USD">USD</option>
                    <option value="PLN">PLN</option>
                    <option value="NOK">NOK</option>
                    <option value="INR">INR</option>
                </select>
            </div>
        </div>
        <?php } ?>
        
        <?php if ($_SESSION['ADMIN_LEVEL'] == 'System') { ?>
            <?php if ($_SESSION['ADMIN_TYPE'] != 'sales') { ?>
                <div class="col-md-3 col-xs-6">
                    <div class="form-group">
                        <label class="sr-only" for="exampleInputEmail2">status</label>
                        <select name="status" class="form-control" id="filter_status">
                            <option value="">Select Status</option>
                            <option value="Declined" <?php echo ($load_status == "declined") ? 'selected' : ''; ?>>Declined</option>
                            <option value="Success" <?php echo ($load_status == "success") ? 'selected' : ''; ?>>Success</option>
                            <option value="Process" <?php echo ($load_status == "Process") ? 'selected' : ''; ?>>Process</option>
                        </select>
                    </div>
                </div>
            <?php } ?>
        <?php } ?>

        <?php if ($_SESSION['ADMIN_LEVEL'] == 'System') { ?>
        <div class="col-md-3 col-xs-6" id="status_reason_div">
            <div class="form-group">
                <label class="sr-only" for="exampleInputEmail2">Select Reason</label>
                <select name="status_reason" class="form-control" id="status_reason">
                    <option value="">Select Reason</option>
                </select>
            </div>
        </div>
        <?php } ?>

        <div class="col-md-3 col-xs-6">
            <div class="form-group">
                <label class="sr-only" for="exampleInputEmail2">Customer Name</label>
                <input type="text" id="customer_name" name="customer_name" placeholder="Customer Name" value=""
                    class="form-control">
            </div>
        </div>

        <div class="col-md-3 col-xs-6">
            <div class="form-group">
                <label class="sr-only" for="exampleInputEmail2">Customer Phone</label>
                <input type="text" id="customer_phone" name="customer_phone" placeholder="Customer Phone" value=""
                    class="form-control">
            </div>
        </div>

        <div class="col-md-3 col-xs-6">
            <div class="form-group">
                <label class="sr-only" for="exampleInputEmail2">Customer Email</label>
                <input type="text" id="customer_email" name="customer_email" placeholder="Customer Email" value=""
                    class="form-control">
            </div>
        </div>

        <?php if ($_SESSION['ADMIN_TYPE'] != 'sales') { ?>
            <div class="col-md-3 col-xs-6">
                <div class="form-group">
                    <input type="text" id="client_transaction_id" name="client_transaction_id"
                        placeholder="CL. Transaction ID" value="" class="form-control">
                </div>
            </div>
        <?php } ?>

        <?php if ($_SESSION['ADMIN_LEVEL'] == "System") { ?>
            <div class="col-md-3 col-xs-6">
                <div class="form-group">
                    <input type="text" id="mid_no" name="mid_no" placeholder="IPN No." value="" class="form-control"
                        autocomplete="off">
                </div>
            </div>
        <?php } ?>
    </div>

    <div class="row">
        <div class="col-md-2 col-xs-6">
            <div class="form-group">
                <button type="button" class="btn btn-primary" onclick="load_table()"><span class="fa fa-search"></span>
                    Search</button>
            </div>
        </div>

        <div class="col-md-2 col-xs-6">
            <div class="form-group">
                <a href="<?php echo base_url() . $this->controllerFile; ?>" class="btn btn-primary"><i
                        class="uil-times"></i>Clear</a>
            </div>
        </div>

        <?php /*if($_SESSION['ADMIN_TYPE']!='moderator'){?>
        <div class="col-md-2 col-xs-6">
            <div class="form-group">
                <a href="javascript:void(0);" class="btn btn-primary" onclick="load_table(1)"><i class="uil-bell"></i> Push Notification</a>
            </div>
        </div>
        <?php }*/ ?>

        <?php if($_SESSION['ADMIN_TYPE']=='superadmin'){?>
        <div class="col-md-2 col-xs-6">
            <div class="form-group">
                <a href="javascript:void(0);" class="btn btn-primary" onclick="load_table(1)"><i class="uil-bell"></i> Push Notification</a>
            </div>
        </div>
        <?php } ?>

        <?php if($_SESSION['ADMIN_TYPE']!='sales'){ 
        ?>
        <div class="col-md-2 col-xs-6">
            <div class="form-group">
                <a href="javascript:void(0);" class="btn btn-primary" onclick="load_table(2)"><i class="uil-import"></i>Download</a>
            </div>
        </div>
        <?php } ?>

        <?php if($_SESSION['ADMIN_TYPE']=='sales'){ 
        ?>
            <div class="col-md-2 col-xs-6">
                <div class="form-group">
                    <a href="javascript:void(0);" class="btn btn-primary" onclick="load_table(3)"><i class="uil-import"></i> Download</a>
                </div>
            </div>
        <?php } ?>

        <div class="col-md-2 col-xs-6">
            <div class="form-group">
                <button type="button" class="btn btn-primary" id="sales_overview">
                    <iconify-icon icon="icon-park-solid:sales-report"></iconify-icon> Sales Overview
                </button>
            </div>
        </div>
    </div>

</form>

<div class="row datatable_div">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-body">
                <table id="example" class="display table table-hover table-condensed" style="width:100%">
                    <thead>
                        <tr>
                            <th>Mid</th>
                            <th>Voucher ID</th>
                            <th>Date</th>
                            <th>Client</th>
                            <?php //<th>T.ID</th> ?>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Redeem Status</th>
                            <th>Response</th>
                            <th>Rf.</th>
                            <th>CB.</th>
                            <th><b style="color:#f0ad4e;">⚠</b>Risk</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div id="gateway_data_modal" class="modal fade" role="dialog">
    <div class="modal-dialog">

        <div class="modal-content modal-lg">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Sales Overview</h4>
            </div>
            <div class="modal-body">

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>

    </div>
</div>

</div>
</div>

<?php $this->load->view('footer'); ?>

<script src="<?php echo base_url(); ?>admin_utils/js/bootstrap-datepicker.js"></script>
<script src="https://bo.xpy.tech/application/views/sales/jquery.dataTables.min.js"></script>
<script type="text/javascript">
    $(document).ready(function (e) {
        $("#overlay").fadeIn(300);
        load_table();
        $('#example_processing').hide();

        $("#status_reason_div").hide();
        $('.dtpkr').datepicker({
            format: "mm-dd-yyyy"
        });
        $('#datepiker1').datepicker({
            format: "mm-dd-yyyy"
        });
        $('#datepiker').datepicker({
            format: "mm-dd-yyyy",
            minDate: new Date(),
        });
        load_init_data();
    });

    function load_table(is_push_notification = 0) {
        if ($.fn.DataTable.isDataTable('#example')) {
            $('#example').DataTable().destroy();
            $('#example tbody').empty();
            $("#overlay").fadeIn(300);
        }

        var start_date = $("#datepiker").val();
        var end_date = $("#datepiker1").val();
        var start_time = $("#start_time").val();
        var end_time = $("#end_time").val();
        var selected_ipn = $("#selected_ipn").val();
        var order_id = $("#order_id").val();
        var gatewayTransactionId = $("#gatewayTransactionId").val();
        var g_type = $("#g_type").val();
        var currency_type = $("#currency_type").val();
        var filter_status = $("#filter_status").val();
        if(filter_status == "" || filter_status == undefined || filter_status == null){
            filter_status = '<?php echo $load_status; ?>';
        }
      //  var redeem_status = $("#redeem_status").val();  //added new line
        
        var status_reason = $("#status_reason").val();
        var customer_name = $("#customer_name").val();
        var customer_phone = $("#customer_phone").val();
        var customer_email = $("#customer_email").val();
        var client_transaction_id = $("#client_transaction_id").val();
        var mid_no = $("#mid_no").val();

        $("#example").DataTable({
            "responsive": true,
            "searching": false,
            "processing": true,
            "serverSide": true,
            "ajax": {
                url: "<?php echo base_url() . $this->controllerFile; ?>load_sales_data",
                data: function (d) {
                    d.start_date = start_date,
                    d.end_date = end_date,
                    d.start_time = start_time,
                    d.end_time = end_time,
                    d.selected_ipn = selected_ipn,
                    d.order_id = order_id,
                    d.gatewayTransactionId = gatewayTransactionId,
                    d.g_type = g_type,
                    d.currency_type = currency_type,
                    d.filter_status = filter_status,
                //    d.filter_redeem_status=filter_redeem_status  //new line
                    d.status_reason = status_reason,
                    d.customer_name = customer_name,
                    d.customer_phone = customer_phone,
                    d.customer_email = customer_email,
                    d.client_transaction_id = client_transaction_id,
                    d.mid_no = mid_no,
                    d.is_push_notification = is_push_notification
                }
            },
            "columns": [{
                data: 'g_type'
            },
            {
                data: 'order_id'
            },
            {
                data: 'date'
            },
            {
                data: 'client'
            },
            //{ data: 't_id' },
            {
                data: 'name'
            },
            {
                data: 'email'
            },
            {
                data: 'amount'
            },
            {
                data: 'status'
            },
            {
              data: 'redeem_status'  
            },
            {
                data: 'response'
            },
            {
                data: 'rf'
            },
            {
                data: 'cb'
            },
            {
                data: 'risk'
            },
            {
                data: 'action'
            }
            ],
            "createdRow": function (row, data, dataIndex) {
                if (data.status_hidden == "Declined") {
                    $(row).addClass('bg-danger')
                } else if (data.status_hidden == "Process") {
                    $(row).addClass('bg-warning')
                } else if (data.status_hidden == "Success") {
                    $(row).addClass('bg-success')
                }
            },
            oLanguage: {
                sProcessing: false
            }
        }).on('init.dt', function () {
            $("#overlay").fadeOut(300);
        }).on('order.dt', function () {
            $('#example_processing').hide();
            $("#overlay").fadeIn(300);
        }).on('page.dt', function () {
            $('#example_processing').hide();
            $("#overlay").fadeIn(300);
        }).on('draw.dt', function () {
            $("#overlay").fadeOut(300);
            if(is_push_notification == 2){
                window.location.href = "<?php echo base_url(); ?>customers/download";
            }else if(is_push_notification == 3){
                window.location.href = "<?php echo base_url() . 'customers/download_sales'; ?>";
            }
        }).on('length.dt', function (e, settings, len) {
            $('#example_processing').hide();
            $("#overlay").fadeIn(300);
        });
    }

    function load_gateway_data() {
        $("#overlay").fadeIn(300);
        var start = parseFloat($("#example_paginate .current").text());
        var length = parseFloat($("select[name='example_length']").val());
        var start_date = $("#datepiker").val();
        var end_date = $("#datepiker1").val();
        var start_time = $("#start_time").val();
        var end_time = $("#end_time").val();
        var selected_ipn = $("#selected_ipn").val();
        var order_id = $("#order_id").val();
        var gatewayTransactionId = $("#gatewayTransactionId").val();
        var g_type = $("#g_type").val();
        var currency_type = $("#currency_type").val();
        var filter_status = $("#filter_status").val();
       var filter_redeem_status = $("filter_redeem_status").val();  //added new status
        var status_reason = $("#status_reason").val();
        var customer_name = $("#customer_name").val();
        var customer_phone = $("#customer_phone").val();
        var customer_email = $("#customer_email").val();
        var client_transaction_id = $("#client_transaction_id").val();
        var mid_no = $("#mid_no").val();

        $.post('<?php echo base_url() . $this->controllerFile; ?>load_gateway_data', $("#frmSearch").serialize() + '&start=' +
            start + '&length=' + length,
            function (data) {
                $("#overlay").fadeOut(300);
                $("#gateway_data_modal .modal-body").html(data);
                $("#gateway_data_modal").modal('show');
            });
    }

    $(document).on('click', '#sales_overview', function () {
        load_gateway_data();
    });

    $('.dp').on('change', function () {
        $('.datepicker').hide();
        var startDate = new Date($('#datepiker').val());
        var endDate = new Date($('#datepiker1').val());

        if (startDate != "" && endDate != '') {
            if (startDate > endDate) {
                alert('End Date Connot be Less than Start Date');
                $("#datepiker1").val('');
            }
        }
    });

    function load_init_data() {
        $.post('<?php echo base_url() . $this->controllerFile; ?>load_sales_init_data', '', function (data) {
            var parsed_data = JSON.parse(data);
            if (parsed_data.ipn_data != "" && parsed_data.ipn_data != null) {
                $("#selected_ipn").html(parsed_data.ipn_data);
            }
            if (parsed_data.gateway_data != "" && parsed_data.gateway_data != null) {
                $("#g_type").html(parsed_data.gateway_data);
            }
        });
    }

    $(document).on('change', '#selected_ipn', function(e){
        var curr_val = $(this).val();
        $("#mid_no").val(curr_val);
    });

    $(document).on('change', '#filter_status', function (e) {
        var selected_val = $(this).val();
        if (selected_val == "Declined") {
            var selected_g_type = $("#g_type").val();
            if (selected_g_type == undefined || selected_g_type == "") {
                alert('Please Select Gateway First');
            } else {
                $("#status_reason_div").show();

                $.post('<?php echo base_url() . $this->controllerFile; ?>get_declined_reason', 'g_type=' +
                    selected_g_type,
                    function (data) {
                        $("#status_reason").html(data);
                    });
            }
        } else {
            $("#status_reason_div").hide();
        }
    });

    $(document).on('change', '#g_type', function (e) {
        var selected_val = $(this).val();
        var selected_status = $("#filter_status").val();
        if ((selected_status != undefined || selected_status != "") && selected_status == "Declined") {
            $("#filter_status").trigger('change');
        }
    });

    function record_status(id, status) {
        var r = confirm("Are you sure to Change the status of transaction?");
        if (r == true) {
            $.post('<?php echo base_url() . $this->controllerFile; ?>change', 'id=' + id + '&status=' + status, function (
                data) {
                if (data) {
                    $("#msgDiv").show("");
                    $('#msgDiv').html(data);
                    $('#msgDiv').delay(5000).fadeOut('slow', function () { });
                    location.reload();
                }
            });
        }
    }

    function showRefund(id) {
        var chk = jQuery("#chkR" + id).val();
        jQuery("#spanR" + id).toggle("slow");
    }

    function submitRefund(id) {
        var chkR = jQuery("#chkR" + id).val();
        var dateR = jQuery("#dateR" + id).val();
        var refund_amount = jQuery("#refund_amount" + id).val();
        var r = confirm("Are you sure to Mark the transaction as Refund?");
        if (r == true) {
            $.post('<?php echo base_url() . $this->controllerFile; ?>changeRefundStatus', 'id=' + id + '&chkR=' + chkR + '&dateR=' + dateR + '&refund_amount=' + refund_amount,
            function (data) {
                if (data) {
                    $("#msgDiv").show("");
                    $('#msgDiv').html(data);
                    $('#msgDiv').delay(5000).fadeOut('slow', function () { });
                    load_table();
                }
            });
        }
    }

    function showCB(id) {
        var chk = jQuery("#chkC" + id).val();
        jQuery("#spanC" + id).toggle("slow");
    }

    function submitCB(id) {
        var chkC = jQuery("#chkC" + id).val();
        var dateC = jQuery("#dateC" + id).val();
        var r = confirm("Are you sure to Mark the transaction as Chargeback?");
        if (r == true) {
            $.post('<?php echo base_url() . $this->controllerFile; ?>changeChargebackStatus', 'id=' + id + '&chkC=' + chkC + '&dateC=' + dateC,
            function (data) {
                if (data) {
                    $("#msgDiv").show("");
                    $('#msgDiv').html(data);
                    $('#msgDiv').delay(5000).fadeOut('slow', function () { });
                    location.reload();
                }
            });
        }
    }

    function showRisk(id) {
        var chk = jQuery("#chkRisk" + id).val();
        jQuery("#spanRisk" + id).toggle("slow");
    }

    function submitRisk(id) {
        var chkC = jQuery("#chkRisk" + id).val();
        var dateC = jQuery("#dateRisk" + id).val();
        var r = confirm("Are you sure to Mark the transaction as Risk?");
        if (r == true) {
            $.post('<?php echo base_url() . $this->controllerFile; ?>changeRiskStatus', 'id=' + id + '&chkC=' + chkC + '&dateC=' + dateC,
            function (data) {
                if (data) {
                    $("#msgDiv").show("");
                    $('#msgDiv').html(data);
                    $('#msgDiv').delay(5000).fadeOut('slow', function () { });
                    location.reload();
                }
            });
        }
    }


    function fnrequestType(requestType) {
        jQuery("#requestType").val(requestType);
    }

    function showHidePhn(phnVal) {
        if (phnVal == 'EnterNumber') {
            jQuery("#phoneBlock").show('slow');
        } else {
            jQuery("#phoneBlock").hide('slow');
        }
    }

    function showHideBlock() {
        jQuery("#billingCompanyShow").toggle('slow');
        jQuery("#customerMailSendBlock").toggle('slow');
    }

    function change_frozen_status(id, val) {
        if (val == 'Y') {
            jQuery("#dateFrozen" + id).show('slow');
        } else {
            var r = confirm("Are you sure to change the Frozen staus of the transaction?");
            if (r == true) {
                $.post('<?php echo base_url() . $this->controllerFile; ?>change_frozen_status', 'id=' + id + '&val=' + val,
                function (data) {
                    if (data) {
                        $("#msgDiv").show("");
                        $('#msgDiv').html(data);
                        $('#msgDiv').delay(5000).fadeOut('slow', function () { });
                        location.reload();
                    }
                });
            }
        }
    }



    function change_frozen_status2(id) {
        var recDate = jQuery("#datepikerFrozen" + id + "").val();
        var val = jQuery("#frozen" + id + "").val();
        var r = confirm("Are you sure to change the Frozen staus of the transaction?");
        if (r == true) {
            $.post('<?php echo base_url() . $this->controllerFile; ?>change_frozen_status', 'id=' + id + '&val=' + val + '&recDate=' + recDate,
            function (data) {
                if (data) {
                    $("#msgDiv").show("");
                    $('#msgDiv').html(data);
                    $('#msgDiv').delay(5000).fadeOut('slow', function () { });
                    location.reload();
                }
            });
        }
    }

    function SetInvoiceId(id) {
        $('#TextInvoiceId').val(id);
        $('#RefundInvoiceId').val(id);
    }



    $('#resendInvoiceForm').submit(function () {
        var total = $(this).find('input[name="emailType[]"]:checked').length;
        if (total < 1) {
            alert("Select at least 1 Email Type");
            return false;
        }
    });



    function changeProduct(invoice_id, companyID, productPeriod, productId) {
        var r = confirm("Are you sure to change the Product of Record?");
        if (r == true) {
            $.post('<?php echo base_url() . $this->controllerFile; ?>changeProduct', 'invoice_id=' + invoice_id + '&companyID=' + companyID + '&productId=' + productId + "&productPeriod=" + productPeriod,
            function (data) {
                if (data) {
                    $("#msgDiv").show("");
                    $('#msgDiv').html('Product Information Changed Successfully');
                    $('#msgDiv').delay(5000).fadeOut('slow', function () { });
                    location.reload();
                }
            });
        }
    }



    function changeProductInfo(id, invoice_id, companyID) {
        var r = confirm("Are you sure to change the Product Information?");
        if (r == true) {
            var productId = jQuery("#productId" + id).val();
            var product_name = jQuery("#product_name" + id).val();
            var productPeriod = jQuery("#productPeriod" + id).val();
            var productDuration = jQuery("#productDuration" + id).val();

            $.post('<?php echo base_url() . $this->controllerFile; ?>changeProductInfo', 'invoice_id=' + invoice_id + '&companyID=' + companyID + '&productId=' + productId + '&product_name=' + product_name + '&productPeriod=' + productPeriod + '&productDuration=' + productDuration,
            function (data) {
                if (data) {
                    $("#msgDiv").show("");
                    $('#msgDiv').html('Product Information Changed Successfully');
                    $('#msgDiv').delay(5000).fadeOut('slow', function () { });
                    location.reload();
                }
            });
        }
    }



    function check_status(gatewayTransactionId, gatewayID, companyID) {
        $('.bolt').show();
        $('#bolt' + gatewayTransactionId).html('<img src="<?php echo base_url(); ?>images/loading.gif" alt=""/>');
        $.post('<?php echo base_url() . $this->controllerFile; ?>check_status', 'gatewayTransactionId=' + gatewayTransactionId + '&gatewayID=' + gatewayID + '&companyID=' + companyID,
        function (data) {
            $('#bolt' + gatewayTransactionId).html('');
            $('#bolt' + gatewayTransactionId).hide("slow");
            $('.statInfo').hide("slow");
            $('#statInfo' + gatewayTransactionId).html(data);
            $('#statInfo' + gatewayTransactionId).show("slow");
        });
    }



    function discard(gatewayTransactionId) {
        $('#statInfo' + gatewayTransactionId).hide("slow");
        $('#bolt' + gatewayTransactionId).show("slow");
    }



    function change_trans_status(id, val, name) {
        if (val == 'Chargeback') {
            var r = confirm("Are you sure to change the state of transaction record for " + name +
                " and use Present Date?");
        } else if (val == 'Settlement') {
            var r = confirm("Are you sure to change the state of transaction record for " + name +
                " and use Present Date?");
        } else {
            var r = confirm("Are you sure to change the state of transaction record for " + name + " ?");
        }

        if (r == true) {
            if (val == 'Refund') {
                jQuery("#refundAmount" + id + "").show();
            } else {
                $.post('<?php echo base_url() . $this->controllerFile; ?>change_trans_type', 'id=' + id + '&val=' + val,
                function (data) {
                    if (data) {
                        $("#msgDiv").show("");
                        $('#msgDiv').html(data);
                        $('#msgDiv').delay(5000).fadeOut('slow', function () { });
                        location.reload();
                    }
                });
            }
        } else if (r == false && val == 'Chargeback') {
            jQuery("#dateChargeback" + id + "").show();
        } else if (r == false && val == 'Settlement') {
            jQuery("#dateSettlement" + id + "").show();
        }
    }



    function change_trans_status2(id, val, name) {
        var recDate = jQuery("#datepiker" + id + "").val();
        $.post('<?php echo base_url() . $this->controllerFile; ?>change_trans_type', 'id=' + id + '&val=' + val + '&recDate=' + recDate,
        function (data) {
            if (data) {
                $("#msgDiv").show("");
                $('#msgDiv').html(data);
                $('#msgDiv').delay(5000).fadeOut('slow', function () { });
                location.reload();
            }
        });
    }



    function change_trans_statusSettle(id, val, name) {
        var recDate = jQuery("#datepikerSettlement" + id + "").val();
        $.post('<?php echo base_url() . $this->controllerFile; ?>change_trans_type', 'id=' + id + '&val=' + val + '&recSettleDate=' + recDate,
        function (data) {
            if (data) {
                $("#msgDiv").show("");
                $('#msgDiv').html(data);
                $('#msgDiv').delay(5000).fadeOut('slow', function () { });
                location.reload();
            }
        });
    }



    function change_trans_status3(id, val, name) {
        var amount = jQuery("#amount" + id + "").val();
        $.post('<?php echo base_url() . $this->controllerFile; ?>change_trans_type', 'id=' + id + '&val=' + val + '&amount=' + amount,
        function (data) {
            if (data) {
                $("#msgDiv").show("");
                $('#msgDiv').html(data);
                $('#msgDiv').delay(5000).fadeOut('slow', function () { });
                location.reload();
            }
        });
    }



    function hdnSort(name, type) {
        document.frmSearch.hdnOrderByFld.value = name;
        if (type == 'ASC')
            document.frmSearch.hdnOrderBy.value = 'DESC';
        else
            document.frmSearch.hdnOrderBy.value = 'ASC';
        document.frmSearch.submit();
    }

    function change_center_status(id, val, companyID) {
        $('#statusDiv' + id).html('<img src="<?php echo base_url(); ?>images/admin/loading.gif" alt=""/>');
        $.post('<?php echo base_url() . $this->controllerFile; ?>change_center_status', 'id=' + id + '&val=' + val +
        '&companyID=' + companyID,
        function (data) {
            if (data) {
                $("#msgDiv").show("");
                $('#msgDiv').delay(5000).fadeOut('slow', function () { });
                alert("Status Updated Successfully");
                location.reload();
            }
        });
    }
</script>