<!DOCTYPE html>
<html>
<head>
	<title>Back Office | Login</title>
	<link rel="stylesheet" type="text/css" href="css/style.css">
	<link href="https://fonts.googleapis.com/css?family=Poppins:600&display=swap" rel="stylesheet">
	<script src="https://kit.fontawesome.com/a81368914c.js"></script>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link href="https://bo.xpy.tech/gentelella-master/production/images/shortlogo.webp" rel="icon"> 
</head>
<style>
    *{
	padding: 0;
	margin: 0;
	box-sizing: border-box;
}

body{
    font-family: 'Poppins', sans-serif;
    overflow: hidden;
}

h1{
    color: #2e2e2e;
}

p{
    color: #2e2e2e;
}

.wave{
	position: fixed;
	bottom: 0;
	left: 0;
	height: 100%;
	z-index: -1;
}

.container{
    width: 100vw;
    height: 100vh;
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    grid-gap :7rem;
    padding: 0 2rem;
}

.img{
	display: flex;
	justify-content: flex-end;
	align-items: center;
}

.login-content{
	display: flex;
	justify-content: flex-start;
	align-items: center;
	text-align: center;
}

.img img{
	width: 500px;
}

form{
	width: 360px;
}

.login-content img{
    height: 100px;
}

.login-content h2{
	margin: 15px 0;
	color: #333;
	text-transform: uppercase;
	font-size: 2.9rem;
}

.login-content .input-div{
	position: relative;
    display: grid;
    grid-template-columns: 7% 93%;
    margin: 25px 0;
    padding: 5px 0;
    border-bottom: 2px solid #d9d9d9;
}

.login-content .input-div.one{
	margin-top: 0;
}

label{
    color: #525252;
    margin-top: 5px;
    margin-bottom: 5px;
}

label:hover{
	color: #38d39f;
}

i{
	color: #949494;
	display: flex;
	justify-content: center;
	align-items: center;
}

i i{
	transition: .3s;
}

i:hover{
	color: #38d39f;
}


a{
	display: block;
	text-align: right;
	text-decoration: none;
	color: #999;
	font-size: 0.9rem;
	transition: .3s;
}

a:hover{
	color: #38d39f;
}

.btn{
	display: block;
	width: 100%;
	height: 50px;
	border-radius: 25px;
	outline: none;
	border: none;
	background-image: linear-gradient(to right, #32be8f, #38d39f, #32be8f);
	background-size: 200%;
	font-size: 1.2rem;
	color: #fff;
	font-family: 'Poppins', sans-serif;
	text-transform: uppercase;
	margin: 1rem 0;
	cursor: pointer;
	transition: .5s;
}
.btn:hover{
	background-position: right;
}

input{
  background: transparent;
  /*color: #FFF;*/
  position: relative;
  border: 1px solid #FFF;
  display: inline-block;
  font-size: 1rem;
  }
input:focus{
        outline: none;
    }
    
@media screen and (max-width: 1050px){
	.container{
		grid-gap: 5rem;
	}
}

@media screen and (max-width: 1000px){
	form{
		width: 290px;
	}

	.login-content h2{
        font-size: 2.4rem;
        margin: 8px 0;
	}

	.img img{
		width: 400px;
	}
}

@media screen and (max-width: 900px){
	.container{
		grid-template-columns: 1fr;
	}

	.img{
		display: none;
	}

	.wave{
		display: none;
	}

	.login-content{
		justify-content: center;
	}
}
</style>
<body>
	<img class="wave" src="https://bo.xpy.tech/gentelella-master/production/images/wave.webp">
	<div class="container">
		<div class="img">
			<img src="https://bo.xpy.tech/gentelella-master/production/images/bg.svg">
		</div>
		<div class="login-content">
		    <?php if($message!=""){ echo $message;  } ?>
            <form method="POST" action="<?php echo base_url();?>home/login">
                <img style="height: 60px;width: 150px;" src="https://bo.xpy.tech/gentelella-master/production/images/logo.webp">
              <!--<h3 class="title"></h3>-->
              <div class="input-div one">
                <label>Email/IPN</label></br>
                <i class="fas fa-user"></i>
                <input type="text" name="username" class="input" placeholder="Enter your IPN here" required="" />
              </div>
              <div class="input-div pass">
                <label>Password</label></br>
                <i class="fas fa-lock"></i>
                <input type="password" name="password" class="input" placeholder="Enter your Password here" required="" />
              </div>
              <div>
                <!--a class="btn btn-default submit" href="index.html">Log in</a-->
				<?php
					if(isset($_COOKIE['login_attempt']) && ($_COOKIE['login_attempt'] >= 5) ){
						echo "Your account is locked for 30 minutes due to 5 failed login attempts";
					}else{
				?>
				<input type="submit" name="submit" value="Log in" style="margin-left: 0;" class="btn btn-success btn-block login_submit" />
				<?php } ?>
                <!--a class="reset_pass" href="#">Lost your password?</a-->
              </div>

              <div class="clearfix"></div>

              <div class="separator">
                <!--p class="change_link">New to site?
                  <a href="#signup" class="to_register"> Create Account </a>
                </p-->

                <div class="clearfix"></div>
                <br />

                <div>
                  <h1><img style="height: 30px;width: 30px;" src="https://bo.xpy.tech/gentelella-master/production/images/shortlogo.webp"> Back Office</h1>
                  <p>©2023-24 All Rights Reserved.</p>
                </div>
              </div>
            </form>
        </div>
    </div>
   
<!--<script type="text/javascript" src="js/main.js"></script>-->

<script>
const inputs = document.querySelectorAll(".input");


function addcl(){
	let parent = this.parentNode.parentNode;
	parent.classList.add("focus");
}

function remcl(){
	let parent = this.parentNode.parentNode;
	if(this.value == ""){
		parent.classList.remove("focus");
	}
}


inputs.forEach(input => {
	input.addEventListener("focus", addcl);
	input.addEventListener("blur", remcl);
});
</script>
</body>
</html>
