<?php
$filter_chart = !empty($_GET['chart']) ? $_GET['chart'] : 'all';
$default_currency = !empty($_GET['currency']) ? $_GET['currency'] : 'EUR';

$this->load->view('header');
$this->table = 't_master_sales';

if ($_SESSION['ADMIN_LEVEL'] == "Company" && $this->session->userdata('ADMIN_TYPE') != 'group') {
	if ($_SESSION["ADMIN_TYPE"] != "moderator") {
		$where_clause .= "ipn_no = '" . addslashes($_SESSION['ADMIN_USERNAME']) . "'";
	} else {
		$where_clause .= "ipn_no = '" . addslashes($_SESSION['user_name']) . "'";

	}
} else if ($this->session->userdata('ADMIN_TYPE') == 'group') {
	$newWhereClause = ' (';
	$groupID = $this->session->userdata('groupID');
	$getCompanyID = $this->db->query("select * from t_groupCenter where groupID=" . $groupID);
	foreach ($getCompanyID->result() as $row) {
		$newWhereClause .= "ipn_no = '" . $row->ipn_no . "' OR ";
	}
	$newWhereClause = substr($newWhereClause, 0, -3);
	$where_clause .= $newWhereClause . ") ";
} else {
	$where_clause = 1;
}
?>
<style>
	.tile-stats .count {
		font-size: 18px;
		font-weight: 700;
		line-height: 1.5;
		margin-top: 8px;
	}

	.tile-stats .icon {
		width: 8px;
	}

	.h3,
	h3 {
		font-size: 22px;
	}
	#overlay{	
		position: fixed;
		top: 0;
		z-index: 100;
		width: 100%;
		height:100%;
		display: none;
		background: rgba(0,0,0,0.6);
		left: 0;
	}
	.cv-spinner {
		height: 100%;
		display: flex;
		justify-content: right;
	}
	.spinner {
		width: 40px;
		height: 40px;
		border: 4px #ddd solid;
		border-top: 4px #2e93e6 solid;
		border-radius: 50%;
		animation: sp-anime 0.8s infinite linear;
	}
	@keyframes sp-anime {
		100% { 
			transform: rotate(360deg); 
		}
	}
	.is-hide{
		display:none;
	}
</style>
<!-- page content -->
<div id="overlay">
  	<div class="cv-spinner">
    	<span class="spinner"></span>
  	</div>
</div>

	<div class="row">
		<div class="col-md-9" style="margin-top: 2rem;">
			<h1 class="bhjklop">Welcome
				<?php echo $_SESSION['ADMIN_FNAME'] . ' ' . $_SESSION['ADMIN_LNAME']; ?>
			</h1>
		</div>
		<div class="col-md-3">
			<div class="form-group">
				<label class="form-label">Change Currency</label>
				<select class="form-control" name="default_currency" id="select_currency">
					<option value="EUR">EUR</option>
					<option value="USD">USD</option>
					<option value="GBP">GBP</option>
					<option value="INR">INR</option>
				</select>
			</div>
		</div>
	</div>
	<div class="row top_tiles">
		<div class="animated flipInY col-lg-3 col-md-3 col-sm-6 col-xs-12">
			<a href="https://bo.xpy.tech/sales">
				<div class="tile-stats clearfix bg-success bjgk animasrt"
					style=" padding: 8.5% 0;  color: white; box-shadow: 0px 0px 30px #fcfcfc; text-align: center;">
					<div style="color:white;opacity:0.3;" class="icon"><i class="uil-transaction"></i></div>
					<div class="count" id="total_transaction"></div>
					<h3 style="color:white;">Total Transaction Amount</h3>
					<p></p>
				</div>
			</a>
		</div>
		<div class="animated flipInY col-lg-3 col-md-3 col-sm-6 col-xs-12">
			<a href="https://bo.xpy.tech/sales?status=success">
				<div class="tile-stats clearfix bg-success animasrt"
					style=" padding: 19% 0; background: #00b09b; background: -webkit-linear-gradient(to right, #00b09b, #96c93d); background: linear-gradient(to right, #00b09b, #96c93d); color: white; box-shadow: 0px 0px 30px #fcfcfc; text-align: center;">
					<div style="color:white;opacity:0.3;" class="icon"><i class=" uil-bill"></i>
					</div>
					<div class="count" id="total_success_transaction"></div>
					<h3 style="color:white;">Total Successful Transactions</h3>
					<p></p>
				</div>
			</a>
		</div>
		<div class="animated flipInY col-lg-3 col-md-3 col-sm-6 col-xs-12">
			<a href="https://bo.xpy.tech/refunds">
				<div class="tile-stats clearfix bg-success animasrt"
					style=" padding: 15% 0; background: #de6262; background: -webkit-linear-gradient(to right, #de6262, #ffb88c); background: linear-gradient(to right, #de6262, #ffb88c); color: white; box-shadow: 0px 0px 30px #fcfcfc; text-align: center;">
					<div style="color:white;opacity:0.3;" class="icon"><i class="uil-folder-check"></i></div>
					<div class="count" id="total_refund_amount"></div>
					<h3 style="color:white;">Total Refund<br /> Amount</h3>
					<p></p>
				</div>
			</a>
		</div>
		<div class="animated flipInY col-lg-3 col-md-3 col-sm-6 col-xs-12">
			<a href="https://bo.xpy.tech/chargebacks">
				<div class="tile-stats clearfix bg-success animasrt"
					style=" padding: 19% 0; background: #ed213a; background: -webkit-linear-gradient(to right, #ed213a, #93291e); background: linear-gradient(to right, #ed213a, #93291e); color: white; box-shadow: 0px 0px 30px #fcfcfc; text-align: center;">
					<div style="color:white;opacity:0.3;" class="icon"><i class="fa fa-gavel"></i></div>
					<div class="count" id="total_chargeback_amount"></div>
					<h3 style="color:white;">Total Chargeback Amount</h3>
					<p></p>
				</div>
			</a>
		</div>
	</div>

	<div class="row" style="margin-bottom: 20px;">
		<div class="col-md-9">&nbsp;</div>
		<div class="col-md-3">
		<label class="form-label">Chart Type</label>
			<select class="form-control" id="chart_filter">
				<option value="all">All</option>
				<!-- <option value="international">International</option> -->
				<option value="domestic">Domestic</option>
				<!-- <option value="risk">Risk</option> -->
			</select>
		</div>
	</div>


	<div class="row" id="first_chart">
		<div class="col-md-12">
			<div class="x_panel">
				<div class="x_title">
					<h2>Transaction Summary <small style="color: #7be100; font-size: 18px; font-weight: 400;">Weekly progress</small></h2>
					<div class="clearfix"></div>
				</div>
				<div class="x_content">
					<div class="col-md-9 col-sm-12 col-xs-12">
						<div class="demo-container" style="height:280px">
							<div id="chartContainer" class="demo-placeholder"></div>
						</div>
						<div class="tiles" id="tiles_container">
							<div class="col-md-4 tile">
								<span class="label label-default" style="background: linear-gradient(to right, #00b09b, #96c93d);padding: 5px;margin-bottom: 5px;display: inline-block;">Total Successful Amount </span>
								<br/>
								<div id="total_successfull_amt"></div>
								<span class="sparkline11 graph" style="height: 160px;"></span>
							</div>
							<div class="col-md-4 tile">
								<span class="label label-default" style="background: linear-gradient(to right, #ed213a, #93291e);padding: 5px;margin-bottom: 5px;display: inline-block;">Total Declined Amount</span>
								<br/>
								<div id="total_declined_amt"></div>
								<span class="sparkline22 graph" style="height: 160px;"></span>
							</div>
							<div class="col-md-4 tile">
								<span class="label label-default" style="background: linear-gradient(-45deg, #ee7752, #a898d4, #23a6d5, #23d5ab);padding: 5px;margin-bottom: 5px;display: inline-block;">Total Transactions</span>
								<br/>
								<div id="total_transaction_detail"></div>
								<span class="sparkline11 graph" style="height: 160px;"></span>
							</div>
						</div>

					</div>
					<div class="col-md-3 col-sm-12 col-xs-12" id="profile_container">
						<div>
							<div class="x_title">
								<h2> Profiles</h2>
								<div class="clearfix"></div>
							</div>
							<ul class="list-unstyled top_profiles scroll-view" id="customer_details">
								
							</ul>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="ovfhfolow">
		<div class="row">
			<div class="col-md-9">
				<div class="x_panel" style="min-height: 90px;">
                  	<div class="x_title">
                  	    <h2 id="transaction_title">Transactions<small style="color: #f4aa00; font-size: 18px; font-weight: 400;">Gatewaywise</small></h2>
						<!--<h2 id="transaction_title">Total Transactions Gatewaywise</h2>-->
						<div class="clearfix"></div>
					</div>
					<div class="x_body">
						<div class="row" id="total_gateway_wise_transactions" style="font-size: 1.5rem;">
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-3">
				<div class="x_panel">
					<div class="form-group">
						<label class="form-label">Select Filter</label>
						<select class="form-control" id="gateway_transaction_filter">
							<option value="total">Total Transactions</option>
							<?php if( $_SESSION["ADMIN_EMAIL"] != "support@gmail.com"){ ?>
								<option value="today" selected="selected">Today</option>
								<option value="this_week">This Week</option>
								<option value="this_month">This Month</option>
							<?php } ?>
						</select>
					</div>
				</div>
			</div>
		</div>
	</div>

</div>
</div>
</div>
</div>
<!-- /page content -->
<?php $this->load->view('footer'); ?>
<script type="text/javascript" src="https://bo.xpy.tech/application/views/jquery.canvasjs.min.js"></script>

<script>
	var is_process = 0;
	function load_preloader(){
		$("#overlay").fadeIn(300);
	}

	function remove_preloader(){
		$("#overlay").fadeOut(300);
	}

	window.onload = function(){  
		load_preloader();
		CanvasJS.addColorSet("customColorSet1",[
			"#dff0d8",
			"#f2dede",
			"#fcf8e3",
			"#3CB371",
			"#90EE90"
		]);
	}

	$(document).ready(function(e){
		$("#select_currency").trigger('change');
		load_all_charts();
		total_gateway_wise_transactions();
	});

	$(document).on('change', '#select_currency', function(e){
		load_preloader();
		var selected_currency = $(this).val();
		$.post('<?php echo base_url().$this->controllerFile; ?>/Dashboard/get_total_statistics_data', 'selected_curr='+selected_currency, function(data){
			var parsed_data = JSON.parse(data);
			$("#total_transaction").html(parsed_data.total_sales);
			$("#total_success_transaction").html(parsed_data.total_success);
			$("#total_refund_amount").html(parsed_data.total_refund);
			$("#total_chargeback_amount").html(parsed_data.total_chargeback);
			remove_preloader();
		});
	});

	function toggleDataSeries(e){
		if (typeof(e.dataSeries.visible) === "undefined" || e.dataSeries.visible) {
			e.dataSeries.visible = false;
		}
		else{
			e.dataSeries.visible = true;
		}
		chart.render();
	}

	function load_all_charts()
	{
		var selected_currency = $("#select_currency").val();
		var chart_filter = $("#chart_filter").val();
		load_preloader();
		$.post('<?php echo base_url().$this->controllerFile; ?>/Dashboard/get_all_chart_load', 'selected_curr='+selected_currency+'&chart_filter='+chart_filter, function(data){
			remove_preloader();
			var parsed_data = JSON.parse(data);
			if(chart_filter == "risk"){
				$("#tiles_container").hide();
				$("#profile_container").hide();

				var chart = new CanvasJS.Chart("chartContainer", {
					colorSet: "customColorSet1",
					animationEnabled: true,
					theme: "light2",
					title:{
						text: ""
					},
					legend:{
						cursor: "pointer",
						verticalAlign: "center",
						horizontalAlign: "right",
						itemclick: toggleDataSeries
					},
					data: [{
						type: "column",
						name: "Success",
						indexLabel: "{y}",
						yValueFormatString: "#0.##",
						showInLegend: true,
						dataPoints: parsed_data.point1
					}]
				});
			}else{
				$("#tiles_container").show();
				$("#profile_container").show();

				$("#total_successfull_amt").html(parsed_data.salesval);
				$("#total_declined_amt").html(parsed_data.declinedval);
				$("#total_transaction_detail").html(parsed_data.transactionval);
				$("#customer_details").html(parsed_data.customer_details_html);

				var chart = new CanvasJS.Chart("chartContainer", {
					colorSet: "customColorSet1",
					animationEnabled: true,
					theme: "light2",
					title:{
						text: ""
					},
					legend:{
						cursor: "pointer",
						verticalAlign: "center",
						horizontalAlign: "right",
						itemclick: toggleDataSeries
					},
					data: [{
						type: "column",
						name: "Success",
						indexLabel: "{y}",
						yValueFormatString: "#0.##",
						showInLegend: true,
						dataPoints: parsed_data.point1
					},{
						type: "column",
						name: "Declined",
						indexLabel: "{y}",
						yValueFormatString: "#0.##",
						showInLegend: true,
						dataPoints: parsed_data.point2
					}]
				});
			}
			chart.render();
		});
	}

	function total_gateway_wise_transactions()
	{
		load_preloader();
		var selected_filter = $("#gateway_transaction_filter").val();
		$.post('<?php echo base_url().$this->controllerFile; ?>/Dashboard/get_gateway_wise_transaction_details', 'selected_filter='+selected_filter, function(data){
			remove_preloader();
			if(selected_filter == "total"){
				$("#transaction_title").text('Total Transactions Gatewaywise');
			}
			else if(selected_filter == "today"){
				$("#transaction_title").text('Today\'s Transactions Gatewaywise');
			}
			else if(selected_filter == "this_week"){
				$("#transaction_title").text('This Week Transactions Gatewaywise');
			}
			else if(selected_filter == "this_month"){
				$("#transaction_title").text('This Months\'s Transactions Gatewaywise');
			}
			$("#total_gateway_wise_transactions").html(data);
		});
	}

	$(document).on('change', '#gateway_transaction_filter', function(){
		total_gateway_wise_transactions();
	});

	$(document).on('change', '#chart_filter', function(e){
		load_all_charts();
	});
</script>