<?php
class Dashboard extends CI_Controller {
	
	function __construct() {
		parent::__construct();
		$this->load->helper(array('url','form','html'));
		$this->load->library(array('session','authentication'));
		$this->authentication->is_loggedin($this->session->userdata('ADMIN_ID'));
		$this->viewfolder = '';
		$this->load->model(array('common_model'));
		$this->namefile = 'Dashboard';
	}
	
	function index() {
		if($_SESSION['ADMIN_TYPE']=='sales'){
			ci_redirect(base_url().'sales');
		}
		$message = '';
		$data = array();
		$order_by_fld = 'id';
		$order_by =	'DESC';	
		$offset='';
		$limit='';
		$where_clause=array();
		$where_clause=array('status'=>'Y');
		$data['message'] = $message;
		$data['where_clause'] = "";
		$this->load->view('dashboard',$data);
	}

	function dashboard_old() {
		if($_SESSION['ADMIN_TYPE']=='sales'){
			ci_redirect(base_url().'sales');
		}
		$message = '';
		$data = array();
		$order_by_fld = 'id';
		$order_by =	'DESC';	
		$offset='';
		$limit='';
		$where_clause=array();
		$where_clause=array('status'=>'Y');
		$data['message'] = $message;
		$data['where_clause'] = "";
		$this->load->view('dashboard_old_8_11_23',$data);
	}

	function dashboard2() {
		if($_SESSION['ADMIN_TYPE']=='sales'){
			ci_redirect(base_url().'sales');
		}
		$message = '';
		$data = array();
		$order_by_fld = 'id';
		$order_by =	'DESC';	
		$offset='';
		$limit='';
		$where_clause=array();
		$where_clause=array('status'=>'Y');
		$data['message'] = $message;
		$data['where_clause'] = "";
		$this->load->view('dashboard2',$data);
	}

	public function get_total_statistics_data()
	{
		$this->table='t_master_sales';
		if($_SESSION['ADMIN_LEVEL']=="Company" && $this->session->userdata('ADMIN_TYPE')!='group'){		
			$where_clause = "";
			if($_SESSION["ADMIN_TYPE"]!="moderator"){
				$where_clause .= "ipn_no = '".addslashes($_SESSION['ADMIN_USERNAME'])."'";
			}else{
				$where_clause .= "ipn_no = '".addslashes($_SESSION['user_name'])."'";

			}
		}
		else if($this->session->userdata('ADMIN_TYPE')=='group' ){
			$row_count = 0;
			$where_clause = "";
			$newWhereClause =' (';
			$groupID=$this->session->userdata('groupID');
			$getCompanyID=$this->db->query("select * from t_groupCenter where groupID=".$groupID);
			foreach($getCompanyID->result() as $row){
				$newWhereClause .="ipn_no = '".$row->ipn_no."' OR ";
				$row_count++;
			}
			$newWhereClause .= substr($newWhereClause, 0, -3);
			$where_clause .= $newWhereClause.")) ";

			if($row_count == 0){
				$where_clause = '1 = 1';	
			}
		}	
		else{
			$where_clause=1;
		}

		$selected_curr = !empty($_POST['selected_curr']) ? $_POST['selected_curr'] : 'EUR';

		//Get Total Transaction Amount
		$saleValues = $this->db->query('SELECT SUM(`grossPrice`) as Sum FROM ' . $this->table . ' where ' . $where_clause . ' and status="Success" AND currency_type = "'.$selected_curr.'"')->result();

		//Get Successfull Transaction Count
		$successCount = $this->db->query('SELECT count(id) as cnt FROM ' . $this->table . ' where ' . $where_clause . ' and status="Success" AND currency_type = "'.$selected_curr.'"')->result();

		$refundValues = $this->db->query('SELECT sum(`grossPrice`) as Sum FROM ' . $this->table . ' where ' . $where_clause . ' and refund="Y" AND currency_type = "'.$selected_curr.'"')->result();

		$chargebackValues = $this->db->query('SELECT sum(`grossPrice`) as Sum FROM ' . $this->table . ' where ' . $where_clause . ' and chargeback="Y" AND currency_type = "'.$selected_curr.'"')->result();

		$return_arr = array(
			'total_sales' => number_format($saleValues[0]->Sum, 2)." ".$selected_curr,
			'total_success' => $successCount[0]->cnt,
			'total_refund' => number_format($refundValues[0]->Sum, 2)." ".$selected_curr,
			'total_chargeback' => number_format($chargebackValues[0]->Sum, 2)." ".$selected_curr,
		);
		echo json_encode($return_arr);
		die;
	}

	public function get_all_chart_load()
	{
		$chart_filter = !empty($_POST['chart_filter']) ? $_POST['chart_filter'] : '';

		$this->table='t_master_sales';
		if($_SESSION['ADMIN_LEVEL']=="Company" && $this->session->userdata('ADMIN_TYPE')!='group'){		
			$where_clause = "";
			if($_SESSION["ADMIN_TYPE"]!="moderator"){
				$where_clause .= "ipn_no = '".addslashes($_SESSION['ADMIN_USERNAME'])."'";
			}else{
				$where_clause .= "ipn_no = '".addslashes($_SESSION['user_name'])."'";

			}
		}
		else if($this->session->userdata('ADMIN_TYPE')=='group' ){
			$row_count = 0;
			$where_clause = "";
			$newWhereClause =' (';
			$groupID=$this->session->userdata('groupID');
			$getCompanyID=$this->db->query("select * from t_groupCenter where groupID=".$groupID);
			foreach($getCompanyID->result() as $row){
				$newWhereClause .="ipn_no = '".$row->ipn_no."' OR ";
				$row_count++;
			}
			$newWhereClause .= substr($newWhereClause, 0, -3);
			$where_clause .= $newWhereClause.")) ";

			if($row_count == 0){
				$where_clause = '1 = 1';	
			}
		}	
		else{
			$where_clause=1;
		}

		if($chart_filter == "risk")
		{
			$saleValuesWeekly = $this->db->query("Select COUNT(id) as cnt, rec_crt_date, WEEK(rec_crt_date,1) as Year FROM " . $this->table . " where rec_crt_date >= '2020:01:01 00:00:00' AND " . $where_clause . " AND risk = 'Y' group by WEEK(rec_crt_date,1) order by id desc limit 5");

			$dataPoints1 = $dataPoints2 = array();
			foreach ($saleValuesWeekly->result() as $a) {
				$dto = new DateTime();
				$dto->setISODate(date('Y', strtotime($a->rec_crt_date)), $a->Year, 1);
				$ret['week_start'] = $dto->format('d/m/Y');
				$dto->modify('+6 days');
				$ret['week_end'] = $dto->format('d/m/Y');

				$dataPoints1[] = array(
					"label" => $ret['week_start'] . '-' . $ret['week_end'],
					"y" => intval($a->cnt),
				);
			}

			echo json_encode(array(
				'point1' => $dataPoints1
			));
		}
		else
		{
			if($chart_filter == "domestic"){
				$saleValuesWeekly = $this->db->query("Select rec_crt_date, WEEK(rec_crt_date,1) as Year, 
				sum(CASE WHEN status='Declined' THEN ROUND(grossPrice,2) else 0 END) as Declined,
				sum(CASE WHEN status='Process' THEN ROUND(grossPrice,2) else 0 END) as Process,
				sum(CASE WHEN status='Success' THEN ROUND(grossPrice,2) else 0 END) as Success FROM ".$this->table." where rec_crt_date >= '2020:01:01 00:00:00' and ".$where_clause." AND currency_type = 'INR' group by WEEK(rec_crt_date,1) order by id desc limit 5");
			}
			else if($chart_filter == "international"){
				$saleValuesWeekly = $this->db->query("Select rec_crt_date, WEEK(rec_crt_date,1) as Year, 
				sum(CASE WHEN status='Declined' THEN ROUND(grossPrice,2) else 0 END) as Declined,
				sum(CASE WHEN status='Process' THEN ROUND(grossPrice,2) else 0 END) as Process,
				sum(CASE WHEN status='Success' THEN ROUND(grossPrice,2) else 0 END) as Success FROM ".$this->table." where rec_crt_date >= '2020:01:01 00:00:00' and ".$where_clause." AND currency_type != 'INR' group by WEEK(rec_crt_date,1) order by id desc limit 5");
			}
			else{
				$saleValuesWeekly = $this->db->query("Select rec_crt_date, WEEK(rec_crt_date,1) as Year, 
				sum(CASE WHEN status='Declined' THEN ROUND(grossPrice,2) else 0 END) as Declined,
				sum(CASE WHEN status='Process' THEN ROUND(grossPrice,2) else 0 END) as Process,
				sum(CASE WHEN status='Success' THEN ROUND(grossPrice,2) else 0 END) as Success FROM ".$this->table." where rec_crt_date >= '2020:01:01 00:00:00' and ".$where_clause." group by WEEK(rec_crt_date,1) order by id desc limit 5");
			}
			
			$dataPoints1 = $dataPoints2 = array();
			foreach($saleValuesWeekly->result() as $a){
				$dto = new DateTime();
				$dto->setISODate(date('Y', strtotime($a->rec_crt_date)), $a->Year, 1);
				$ret['week_start'] = $dto->format('d/m/Y');
				$dto->modify('+6 days');
				$ret['week_end'] = $dto->format('d/m/Y');
		
				$dataPoints1[]=array(
					"label" => $ret['week_start'].'-'.$ret['week_end'],
					"y" => floatval($a->Success),
				);

				$dataPoints2[]=array(
					"label" => $ret['week_start'].'-'.$ret['week_end'],
					"y" => floatval($a->Declined),
				);
			}

			//Get Sales Value
			if($chart_filter == "domestic"){
				$saleValues = $this->db->query('SELECT sum(`grossPrice`) as Sum, status, count(id) as cnt,currency_type FROM '.$this->table.' where '.$where_clause.' and status="Success" AND currency_type = "INR" group by currency_type');
			}
			else if($chart_filter == "international"){
				$saleValues = $this->db->query('SELECT sum(`grossPrice`) as Sum, status, count(id) as cnt,currency_type FROM '.$this->table.' where '.$where_clause.' and status="Success" AND currency_type != "INR" group by currency_type');
			}else{
				$saleValues = $this->db->query('SELECT sum(`grossPrice`) as Sum, status, count(id) as cnt,currency_type FROM '.$this->table.' where '.$where_clause.' and status="Success" group by currency_type');
			}

			$salesvalue_html = "";

			if(!is_null($saleValues)):
				foreach($saleValues->result() as $saleValues){						  
					if($saleValues->Sum > 0 ){
						$salesvalue_html .= "<span class='label label-success'>".number_format($saleValues->Sum,2).$saleValues->currency_type.'</span><br/>';
					}else{
						$salesvalue_html .= ' -- ';
					}
				}
			else:
				$salesvalue_html .= "--";
			endif;



			//Get Declined Value
			if($chart_filter == "domestic"){
				$declinedValues = $this->db->query('SELECT sum(`grossPrice`) as Sum,status, count(id) as cnt,currency_type FROM '.$this->table.' where '.$where_clause.' and status="Declined" AND currency_type = "INR" group by currency_type');
			}
			else if($chart_filter == "international"){
				$declinedValues = $this->db->query('SELECT sum(`grossPrice`) as Sum,status, count(id) as cnt,currency_type FROM '.$this->table.' where '.$where_clause.' and status="Declined" AND currency_type != "INR" group by currency_type');
			}else{
				$declinedValues = $this->db->query('SELECT sum(`grossPrice`) as Sum,status, count(id) as cnt,currency_type FROM '.$this->table.' where '.$where_clause.' and status="Declined" group by currency_type');
			}
			$sales_declined_val = "";
			
			foreach($declinedValues->result() as $declinedValues){
				if($declinedValues->Sum > 0 ){
					$sales_declined_val .= "<span class='label label-danger'>".number_format($declinedValues->Sum,2).$declinedValues->currency_type."</span><br/>";
				}else{
					$sales_declined_val .= ' -- ';
				}
			}


			//All transaction details
			if($chart_filter == "domestic"){
				$allTransactions = $this->db->query('SELECT sum(`grossPrice`) as Sum,status, count(id) as cnt,currency_type FROM '.$this->table.' where '.$where_clause.' AND currency_type = "INR"')->row();
			}
			else if($chart_filter == "international"){
				$allTransactions = $this->db->query('SELECT sum(`grossPrice`) as Sum,status, count(id) as cnt,currency_type FROM '.$this->table.' where '.$where_clause.' AND currency_type != "INR"')->row();
			}else{
				$allTransactions = $this->db->query('SELECT sum(`grossPrice`) as Sum,status, count(id) as cnt,currency_type FROM '.$this->table.' where '.$where_clause)->row();
			}
			
			$transaction_html = "<span class='label label-success'>".number_format($allTransactions->cnt)."</span>";


			//Profiles details
			if($chart_filter == "domestic"){
				$getCustomers=$this->db->query("Select customer_name, grossPrice, currency_type, rec_crt_date from ".$this->table." where ".$where_clause." and status='Success' AND currency_type = 'INR' order by id desc limit 0,5 ");
			}
			else if($chart_filter == "international"){
				$getCustomers=$this->db->query("Select customer_name, grossPrice, currency_type, rec_crt_date from ".$this->table." where ".$where_clause." and status='Success' AND currency_type != 'INR' order by id desc limit 0,5 ");
			}else{
				$getCustomers=$this->db->query("Select customer_name, grossPrice, currency_type, rec_crt_date from ".$this->table." where ".$where_clause." and status='Success' order by id desc limit 0,5 ");
			}
			$customer_details_html = "";
			$rowNo = 0;

			foreach($getCustomers->result() as $cusRow)
			{
				$customer_details_html .= '<li class="media event">';
					$customer_details_html .= '<a class="pull-left border-aero ertyuio">';
						$customer_details_html .= '<i class="avgtyu"><img src="https://bo.livitpay.com/gentelella-master/production/images/user.png" width="40px"></i>';
					$customer_details_html .= '</a>';
					$customer_details_html .= '<div class="media-body">';
						$customer_details_html .= '<a class="title" href="#">'.ucwords(strtolower($cusRow->customer_name)).'</a>';
						$customer_details_html .= '<p><strong>'.$cusRow->grossPrice.$cusRow->currency_type.'</strong></p>';
						$customer_details_html .= '<p> <small>'.date("M-d,Y",strtotime($cusRow->rec_crt_date)).'</small></p>';
					$customer_details_html .= '</div>';
				$customer_details_html .= '</li>';

				$rowNo++;
			}

			echo json_encode(array(
				'point1' => $dataPoints1,
				'point2' => $dataPoints2,
				'salesval' => $salesvalue_html,
				'declinedval' => $sales_declined_val,
				'transactionval' => $transaction_html,
				'customer_details_html' => $customer_details_html
			));
		}
	}

	public function get_gateway_wise_transaction_details()
	{
		$this->table='t_master_sales';
		if($_SESSION['ADMIN_LEVEL']=="Company" && $this->session->userdata('ADMIN_TYPE')!='group'){		
			$where_clause = "";
			if($_SESSION["ADMIN_TYPE"]!="moderator"){
				$where_clause .= "ipn_no = '".addslashes($_SESSION['ADMIN_USERNAME'])."'";
			}else{
				$where_clause .= "ipn_no = '".addslashes($_SESSION['user_name'])."'";

			}
		}
		else if($this->session->userdata('ADMIN_TYPE')=='group' ){
			$row_count = 0;
			$where_clause = "";
			$newWhereClause =' (';
			$groupID=$this->session->userdata('groupID');
			$getCompanyID=$this->db->query("select * from t_groupCenter where groupID=".$groupID);
			foreach($getCompanyID->result() as $row){
				$newWhereClause .="ipn_no = '".$row->ipn_no."' OR ";
				$row_count++;
			}
			$newWhereClause .= substr($newWhereClause, 0, -3);
			$where_clause .= $newWhereClause.")) ";

			if($row_count == 0){
				$where_clause = '1 = 1';	
			}
		}	
		else{
			$where_clause=1;
		}

		$return_html = "";

		$selected_filter = !empty($_POST['selected_filter']) ? $_POST['selected_filter'] : 'total';
		if($selected_filter == "total")
		{
			$gatewayTrQuery="Select g_type, 
			sum(CASE WHEN status='Declined' THEN ROUND(grossPrice,2) else 0 END) as Declined,
			sum(CASE WHEN status='Process' THEN ROUND(grossPrice,2) else 0 END) as Process,
			sum(CASE WHEN status='Success' THEN ROUND(grossPrice,2) else 0 END) as Success,
			sum(CASE WHEN refund='Y' THEN ROUND(grossPrice,2) else 0 END) as Refund,
			sum(CASE WHEN chargeback='Y' THEN ROUND(grossPrice,2) else 0 END) as Chargeback,
			count(distinct case when status = 'Declined' then id END) as declinedCount,
			count(distinct case when status = 'Process' then id END) as processCount,
			count(distinct case when status = 'Success' then id END) as successCount,
			count(distinct case when refund='Y' then id END) as refundCount,
			count(distinct case when chargeback='Y'then id END) as chargebackCount,
			currency_type FROM ".$this->table." where ".$where_clause." group by g_type, currency_type order by g_type";
		}
		else if($selected_filter == "today")
		{
			$gatewayTrQuery="Select g_type, 
			sum(CASE WHEN status='Declined' THEN ROUND(grossPrice,2) else 0 END) as Declined,
			sum(CASE WHEN status='Process' THEN ROUND(grossPrice,2) else 0 END) as Process,
			sum(CASE WHEN status='Success' THEN ROUND(grossPrice,2) else 0 END) as Success,
			sum(CASE WHEN refund='Y' THEN ROUND(grossPrice,2) else 0 END) as Refund,
			sum(CASE WHEN chargeback='Y' THEN ROUND(grossPrice,2) else 0 END) as Chargeback,
			count(distinct case when status = 'Declined' then id END) as declinedCount,
			count(distinct case when status = 'Process' then id END) as processCount,
			count(distinct case when status = 'Success' then id END) as successCount,
			count(distinct case when refund='Y' then id END) as refundCount,
			count(distinct case when chargeback='Y'then id END) as chargebackCount,
			currency_type FROM ".$this->table." where ".$where_clause." and rec_crt_date > '".date('Y-m-d 00:00:00')."' group by g_type, currency_type order by Success,g_type";
		}
		else if($selected_filter == "this_week")
		{
			$todayDay=date('l');
			if($todayDay=='Monday'){
				$thisDay=date('Y-m-d 00:00:00');
			}	
			else{
				$thisDay=date('Y-m-d 00:00:00',strtotime('-1 Monday'));
			}

			$gatewayTrQuery = "Select g_type, 
			sum(CASE WHEN status='Declined' THEN ROUND(grossPrice,2) else 0 END) as Declined,
			sum(CASE WHEN status='Process' THEN ROUND(grossPrice,2) else 0 END) as Process,
			sum(CASE WHEN status='Success' THEN ROUND(grossPrice,2) else 0 END) as Success,
			sum(CASE WHEN refund='Y' THEN ROUND(grossPrice,2) else 0 END) as Refund,
			sum(CASE WHEN chargeback='Y' THEN ROUND(grossPrice,2) else 0 END) as Chargeback,
			count(distinct case when status = 'Declined' then id END) as declinedCount,
			count(distinct case when status = 'Process' then id END) as processCount,
			count(distinct case when status = 'Success' then id END) as successCount,
			count(distinct case when refund='Y' then id END) as refundCount,
			count(distinct case when chargeback='Y'then id END) as chargebackCount,
			currency_type FROM ".$this->table." where ".$where_clause." and rec_crt_date > '".$thisDay."' and rec_crt_date <= '".date('Y-m-d 23:59:59')."' group by g_type, currency_type order by g_type";
		}
		else if($selected_filter == "this_month")
		{
			$gatewayTrQuery = "Select g_type, 
			sum(CASE WHEN status='Declined' THEN ROUND(grossPrice,2) else 0 END) as Declined,
			sum(CASE WHEN status='Process' THEN ROUND(grossPrice,2) else 0 END) as Process,
			sum(CASE WHEN status='Success' THEN ROUND(grossPrice,2) else 0 END) as Success,
			sum(CASE WHEN refund='Y' THEN ROUND(grossPrice,2) else 0 END) as Refund,
			sum(CASE WHEN chargeback='Y' THEN ROUND(grossPrice,2) else 0 END) as Chargeback,
			count(distinct case when status = 'Declined' then id END) as declinedCount,
			count(distinct case when status = 'Process' then id END) as processCount,
			count(distinct case when status = 'Success' then id END) as successCount,
			count(distinct case when refund='Y' then id END) as refundCount,
			count(distinct case when chargeback='Y'then id END) as chargebackCount,
			currency_type FROM ".$this->table." where ".$where_clause." and rec_crt_date > '".date('Y-m-01 00:00:00')."' and rec_crt_date <= '".date('Y-m-d 23:59:59')."'  group by g_type, currency_type order by g_type";
		}

		$gatewayValues = $this->db->query($gatewayTrQuery);
		foreach($gatewayValues->result() as $gatewayValues)
		{
			if(!empty($gatewayValues->g_type)){
				$return_html .= "<div class='col-md-2'>";
					$return_html .= "<strong><span class='label label-info'>".$gatewayValues->g_type.":</span>";
				$return_html .= "</div>";

				$return_html .= "<div class='col-md-3'>";
					if(!empty($gatewayValues->successCount)){
						$return_html .= "<strong><span class='label label-success'>Success: ".number_format($gatewayValues->Success,2).$gatewayValues->currency_type."(".$gatewayValues->successCount.")</span>";
					}
				$return_html .= "</div>";

				$return_html .= "<div class='col-md-3'>";
					if(!empty($gatewayValues->declinedCount)){
						$return_html .= "<strong><span class='label label-danger'>Declined: ".number_format($gatewayValues->Declined,2).$gatewayValues->currency_type."(".$gatewayValues->declinedCount.")</span>";
					}
				$return_html .= "</div>";

				$return_html .= "<br/>";
			}
		}

		if($selected_filter == "today")
		{
			$saleValuesToday = $this->db->query('SELECT sum(`grossPrice`) as Sum, currency_type FROM '.$this->table.' where '.$where_clause.' and status="Success" and rec_crt_date > "'.date('Y-m-d 00:00:00').'" group by currency_type');
			foreach($saleValuesToday->result() as $gatewayValues){
				$return_html .= "<br/>";
				$return_html .= "<div class='col-md-3'>";
					$return_html .= "<strong><span class='label label-success'>Total: ".number_format($gatewayValues->Sum,2).$gatewayValues->currency_type."</span>";
				$return_html .= "</div>";
			}
		}

		echo $return_html;
	}
}
// end of class
?>