<?php
class Customer extends CI_Controller {
	
	function __construct() {
		parent::__construct();
		//error_reporting(E_ALL);
		$this->load->helper(array('url','form','html'));
		$this->load->library(array('session','authentication','encryption','pagination'));
		$this->authentication->is_loggedin($this->session->userdata('ADMIN_ID'));
		$this->authentication->is_superAdmin($this->session->userdata('ADMIN_TYPE'));
		$this->viewfolder 		= 'customer';
		$this->TableCustomer 	= 't_customer';
		$this->TableAgent 		= 't_admin';
		$this->TableProduct 	= 't_product';
		$this->TableNote 		= 't_customer_notes';
		$this->TableInvoice 	= 't_invoice';
		$this->TableProduct 	= 't_product';
		$this->TableCase 		= 't_case';
		$this->load->model(array('common_model'));
		
		if($this->session->userdata('ADMIN_TYPE') == 'sales'){
			redirect(base_url('').'dashboard', 'refresh');
		}
	}
	
	function all_customers() {
		
		$agetID							=	$this->encryption->decode($this->input->post("agetID"));
		$CustomerPin					=	$this->input->post("CustomerPin");
		$CustomerEmail					=	$this->input->post("CustomerEmail");
		$CustomerPhone					=	$this->input->post("CustomerPhone");
		$CustomerName					=	$this->input->post("CustomerName");
		
		/*if($agetID != ''){
			$where_clause = array( 'agentId' => $agetID );
		}
		
		if($CustomerPin != ''){
			$where_clause = array( 'pin' => $CustomerPin );
		}
		
		if($CustomerEmail != ''){
			$where_clause = array( 'email' => $CustomerEmail );
		}
		
		if($CustomerPhone != ''){
			$where_clause = array( 'phone' => $CustomerPhone );
		}
		if($CustomerName != ''){
			$where_clause = array( 'name' => $CustomerName );
		}*/		
		
		if($agetID != ''){
			//$where_clause = array( 'agentId' => $agetID );
			$where_clause .= "agentId = '".addslashes($agetID)."' AND ";
			$data['agetID']=$agetID;
			
		}
		
		if($CustomerPin != ''){
			//$where_clause = array( 'pin' => $CustomerPin );
			$where_clause .= "pin = '".addslashes($CustomerPin)."' AND ";
			$data['CustomerPin']=$CustomerPin;
			
		}
		
		if($CustomerEmail != ''){
			//$where_clause = array( 'email' => $CustomerEmail );
			$where_clause .= "email = '".addslashes($CustomerEmail)."' AND ";
			$data['CustomerEmail']=$CustomerEmail;
		}
		
		if($CustomerPhone != ''){
			//$where_clause = array( 'phone' => $CustomerPhone );
			$where_clause .= "phone like '%".addslashes($CustomerPhone)."%' AND ";
			$data['CustomerPhone']=$CustomerPhone;
		}
		if($CustomerName != ''){
			//$where_clause = array( 'name' => $CustomerName );
			$where_clause .= "name like '%".addslashes($CustomerName)."%' AND ";
			$data['CustomerName']=$CustomerName;
		}
		if($this->session->userdata('COMPANYID') != '')
		{
			$COMPANYID = $this->session->userdata('COMPANYID');
			$where_clause .= "companyID LIKE '%".addslashes($COMPANYID)."%' AND ";
		}		
		
		//echo $where_clause.'<br/>';
		@$where  = substr($where_clause, 0, -4);
		
		$data['result_agent'] 			= $this->common_model->GetAll($this->TableAgent);
		//$total_rows 				    = $this->common_model->countAll($this->TableCustomer,$where_clause);
		$total_rows 				    = $this->common_model->countAll($this->TableCustomer,$where);
		$data['total_rows'] = $total_rows;
		//echo $this->db->last_query();
		$offset 						= (int)$this->uri->segment(3,0);
		$limit 							= 20;
		//Pagination config
		$config['base_url'] 		= base_url()."customer/all-customers/";
		$config['uri_segment']  	= 3;
		$config['total_rows'] 		= $total_rows;
		$config['per_page'] 		= $limit;
		$config['full_tag_open'] 	= '<div class="pagination">';
		$config['full_tag_close'] 	= '</div>';
		$config['full_tag_open'] 	= "<ul class='pagination'>";
		$config['full_tag_close'] 	= "</ul>";
		$config['num_tag_open'] 	= '<li>';
		$config['num_tag_close'] 	= '</li>';
		$config['cur_tag_open'] 	= "<li class='disabled'><li class='active'><a href='#'>";
		$config['cur_tag_close'] 	= "<span class='sr-only'></span></a></li>";
		$config['next_tag_open'] 	= "<li>";
		$config['next_tagl_close'] 	= "</li>";
		$config['prev_tag_open'] 	= "<li>";
		$config['prev_tagl_close'] 	= "</li>";
		$config['first_tag_open'] 	= "<li>";
		$config['first_tagl_close'] = "</li>";
		$config['last_tag_open'] 	= "<li>";
		$config['last_tagl_close'] 	= "</li>";
				
		$this->pagination->initialize($config);
		
		$paginator 					= $this->pagination->create_links();
		$data['links'] 				= $paginator;
		//$data['ResultCustomer'] 	= $this->common_model->get_all_records($this->TableCustomer, $where_clause,'id','DESC',$offset,$limit);
		$data['ResultCustomer'] 	= $this->common_model->get_all_records($this->TableCustomer, $where,'id','DESC',$offset,$limit);
		//echo $this->db->last_query();
		$this->load->view($this->viewfolder.'/all_customer',$data);
	}
	
	function add_customer() {
		
		$data['result_agent'] 			= $this->common_model->GetAll($this->TableAgent);
			
		$this->load->view($this->viewfolder.'/add_customer',$data);
	}
	
	function insert(){
		
		$this->load->helper('unique_number');
		
		$insert['pin']							=	unique_pin();	
		$insert['companyID']					=	$this->session->userdata('COMPANYID');	
		$insert['agentId']						=	$this->encryption->decode($this->input->post("agetID"));
		$insert['name']							=	$this->input->post("FirstName").' '.$this->input->post("LastName");
		$insert['email']						=	$this->input->post("email");
		$insert['phone']						=	$this->input->post("PhoneNumber");
		$insert['address']						=	$this->input->post("address");
		$insert['city']							=	$this->input->post("city");
		$insert['state']						=	$this->input->post("state");
		$insert['zip']							=	$this->input->post("zip");
		$insert['country']						=	$this->input->post("country");
		$insert['rec_crt_date']					=	date('c');
		$insert['rec_up_date']					=	date('c');
		$insert['refType']						=	'1';
				 	
		
		$this->common_model->Add_Record($insert,$this->TableCustomer);
		
		
		// success
		$this->session->set_flashdata('success', 'Product added successfully');
		redirect('customer/all-customers', 'refresh');
		
	}
	
	function customer_edit() {
		$id								= $this->encryption->decode($this->input->get("id"));
		$data['result_agent'] 			= $this->common_model->GetAll($this->TableAgent);
		$data['result_customer'] 		= $this->common_model->Retrive_Record_By_Where_Clause2($this->TableCustomer,array('id'=>$id));
			
		$this->load->view($this->viewfolder.'/edit_customer',$data);
	}

	
	
	function update_customer(){
		$id		 								=   $this->encryption->decode($this->input->post('customerID'));
		
		$update['agentId']						=	$this->encryption->decode($this->input->post("agetID"));
		$update['name']							=	$this->input->post("name");
		$update['email']						=	$this->input->post("email");
		$update['phone']						=	$this->input->post("PhoneNumber");
		$update['address']						=	$this->input->post("address");
		$update['city']							=	$this->input->post("city");
		$update['state']						=	$this->input->post("state");
		$update['zip']							=	$this->input->post("zip");
		$update['country']						=	$this->input->post("country");
		$update['rec_up_date']					=	date('c');
		
		$this->common_model->Update_Record($update,$this->TableCustomer,$id);
		// success
		$this->session->set_flashdata('success', 'Customer updated successfully');
		redirect('customer/all-customers', 'refresh');
	}	
	
	function customer_delete(){
		$id		 	= $this->encryption->decode($this->input->get('id'));
		$this->common_model->delfn($this->TableCustomer,$id);
		
		// success
		$this->session->set_flashdata('success', 'Customer deleted successfully');
		redirect('customer/all-customers', 'refresh');
	}
	
	function customer_details() {
		//error_reporting(E_ALL);
		$id								= $this->encryption->decode($this->input->get("id"));
		$data['result_agent'] 			= $this->common_model->GetAll($this->TableAgent);
		$data['result_product'] 		= $this->common_model->GetAll($this->TableProduct);
		$data['result_invoice'] 		= $this->common_model->Retrive_Record_By_Where_Clause2($this->TableInvoice,array('customerId'=>$id,'sale_type' => 0));
		$data['result_customer'] 		= $this->common_model->Retrive_Record_By_Where_Clause2($this->TableCustomer,array('id'=>$id));
		$data['result_case'] 			= $this->common_model->get_all_records($this->TableCase, array('customerID'=>$id),'caseID','DESC','','');
		
		//$this->common_model->Retrive_Record_By_Where_Clause2($this->TableCase,array('customerID'=>$id));	
		$this->load->view($this->viewfolder.'/customer_details',$data);
	}
	
	function note(){
		
		$result_agent 							=   $this->common_model->GetAll($this->TableAgent);
		$insert['agentID']						=	$this->session->userdata('ADMIN_ID');
		$insert['customerID']					=	$this->encryption->decode($this->input->post("customerID"));
		$insert['note']							=	$this->input->post("note");
		
		if($this->encryption->decode($this->input->post("note")) != ''){
			$this->common_model->Add_Record($insert,$this->TableNote);
		}
		
		$ResultNote 	= $this->common_model->get_all_records($this->TableNote, array( 'customerID' => $this->encryption->decode( $this->input->post("customerID") )),'noteID','DESC','','');
		
		foreach ($ResultNote->result() as $row){
			
					foreach ($result_agent->result() as $result_agent_row)
                        {
                            if($row->agentID == $result_agent_row->id){
							$agent = $result_agent_row->aliasName.' ('.$result_agent_row->name.')';
							}
                        }
			
		echo '<div class="clearfix">
		 	  <p>'.$row->note.'</p>
		      <span class="pull-right">By <b>'.$agent.'</b></span>
		      <span class="pull-left"><b>'.date("d M,y g:i a",strtotime($row->insert_time)).'</b></span>
		      </div><hr/>';
		}
		
	}
	
	
	function get_phone() {
		//error_reporting(E_ALL);
		$id						= $this->encryption->decode($this->input->post("id"));
		
		$result_customer 		= $this->common_model->Retrive_Record_By_Where_Clause2($this->TableCustomer,array('id'=>$id));
		
		foreach ($result_customer->result() as $row)
		{
			my_loginfo_function('2',$row->phone);
			echo $row->phone;
		}
		
		
	}
	
	function get_email() {
		//error_reporting(E_ALL);
		$id						= $this->encryption->decode($this->input->post("id"));
		
		$result_customer 		= $this->common_model->Retrive_Record_By_Where_Clause2($this->TableCustomer,array('id'=>$id));
		
		foreach ($result_customer->result() as $row)
		{
			my_loginfo_function('1',$row->email);
			echo $row->email;
		}
		
		
	}
	
	
}
// end of class
?>